/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.ScissorWidget;
import com.supermartijn642.core.gui.widget.premade.ScrollbarWidget;
import com.supermartijn642.core.gui.widget.premade.TextFieldWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingBlockShape;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingRecipeManager;
import com.supermartijn642.rechiseled.api.chiseling.ItemWithWorth;
import com.supermartijn642.rechiseled.packet.PacketChiselAll;
import com.supermartijn642.rechiseled.packet.PacketSelectEntry;
import com.supermartijn642.rechiseled.screen.BaseChiselingContainer;
import com.supermartijn642.rechiseled.screen.ChiselAllWidget;
import com.supermartijn642.rechiseled.screen.ConnectingToggleWidget;
import com.supermartijn642.rechiseled.screen.DisplayEntry;
import com.supermartijn642.rechiseled.screen.EntryButtonWidget;
import com.supermartijn642.rechiseled.screen.FilterOptionsWidget;
import com.supermartijn642.rechiseled.screen.ShapeSelectionWidget;
import com.supermartijn642.rechiseled.screen.preview.EntryPreviewWidget;
import com.supermartijn642.rechiseled.screen.preview.PreviewMode;
import com.supermartijn642.rechiseled.screen.preview.PreviewModeButtonWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;

public class BaseChiselingContainerScreen<T extends BaseChiselingContainer>
extends BaseContainerWidget<T> {
    private static final ResourceLocation BACKGROUND = Rechiseled.identifier("textures/screen/chiseling_background.png");
    private static final int OPTION_ROWS = 5;
    private static final int OPTION_COLUMNS = 6;
    private static PreviewMode previewMode = PreviewMode.SINGLE;
    private static String searchText = "";
    private static String formattedSearchText = "";
    private static boolean showBlocks = true;
    private static boolean showStairs = false;
    private static boolean showSlabs = false;
    private static boolean showNonConnecting = true;
    private static boolean filtersMatchShape = true;
    private final Component title;
    private ChiselAllWidget chiselAllWidget;
    private final List<EntryButtonWidget> entryButtons = new ArrayList<EntryButtonWidget>();
    private TextFieldWidget searchField;
    private FilterOptionsWidget filterOptionsWidget;
    private DisplayEntry lastContainerEntry;
    private ChiselingRecipe recipe;
    private final List<DisplayEntry> allEntries = new ArrayList<DisplayEntry>();
    private final List<DisplayEntry> visibleEntries = new ArrayList<DisplayEntry>();
    private DisplayEntry selectedEntry;
    private boolean connecting = false;
    private float scrollOffset;
    private int scrollIndexOffset;

    public BaseChiselingContainerScreen(Component title) {
        super(0, 0, 260, 243);
        this.title = title;
    }

    protected void addWidgets() {
        ScissorWidget scissorWidget = (ScissorWidget)this.addWidget((Widget)ScissorWidget.create((int)9, (int)34, (int)120, (int)110, (Widget[])new Widget[0]));
        for (int row = 0; row < 6; ++row) {
            for (int column = 0; column < 6; ++column) {
                int index = row * 6 + column;
                int x = 9 + 20 * column;
                int y = 34 + 22 * row;
                EntryButtonWidget button = new EntryButtonWidget(x, y, 20, 22, () -> this.getDisplayEntry(index), () -> this.selectedEntry, () -> this.selectDisplayEntry(this.getDisplayEntry(index)), () -> this.connecting);
                scissorWidget.addWidget((Widget)button);
                this.entryButtons.add(button);
            }
        }
        this.addWidget((Widget)ScrollbarWidget.builder((int)110).position(132, 34).scrollValue(() -> this.scrollOffset, () -> 0.0, () -> (int)Math.ceil((float)this.visibleEntries.size() / 6.0f) - 5).onChange((oldValue, newValue) -> this.setScrollOffset((float)newValue)).smoothScrolling().scrollWheelValueChange(0.0).background(null).build());
        this.searchField = (TextFieldWidget)this.addWidget((Widget)new TextFieldWidget(8, 18, 122, 12, "", 20, s -> {
            if (!(s = s.trim()).equals(searchText)) {
                searchText = s;
                formattedSearchText = s.toLowerCase();
                this.updateDisplayEntries();
            }
        }));
        this.searchField.setSuggestion("Search");
        this.searchField.setTextSuppressed(searchText);
        this.searchField.setActive(false);
        this.filterOptionsWidget = (FilterOptionsWidget)this.addWidget((Widget)new FilterOptionsWidget(131, 18, () -> showBlocks, () -> showStairs, () -> showSlabs, () -> showNonConnecting, this::toggleShowBlocks, this::toggleShowStairs, this::toggleShowSlabs, this::toggleShowNonConnecting, () -> {
            showNonConnecting = true;
            showSlabs = true;
            showStairs = true;
            showBlocks = true;
            filtersMatchShape = false;
            this.updateDisplayEntries();
        }));
        this.filterOptionsWidget.setActive(false);
        this.addWidget((Widget)new EntryPreviewWidget(155, 20, 68, 69, () -> {
            DisplayEntry display = this.selectedEntry;
            ItemWithWorth item = display == null ? null : display.getItem(this.connecting);
            return item == null ? null : item.item();
        }, () -> previewMode));
        Supplier<Boolean> enablePreviewButtons = () -> {
            DisplayEntry display = this.selectedEntry;
            ItemWithWorth item = display == null ? null : display.getItem(this.connecting);
            return item != null && item.item() instanceof BlockItem;
        };
        this.addWidget((Widget)new PreviewModeButtonWidget(227, 21, 19, 21, PreviewMode.PANEL, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = PreviewMode.PANEL;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(227, 44, 19, 21, PreviewMode.ROW, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = PreviewMode.ROW;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(227, 67, 19, 21, PreviewMode.SINGLE, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = PreviewMode.SINGLE;
        }));
        this.addWidget((Widget)new ConnectingToggleWidget(229, 112, 15, 16, () -> this.connecting, () -> this.selectedEntry, this::toggleConnecting));
        this.addWidget((Widget)new ShapeSelectionWidget(210, 99, 12, 13, ChiselingBlockShape.BLOCK, () -> this.selectedEntry, () -> this.changeShape(ChiselingBlockShape.BLOCK)));
        this.addWidget((Widget)new ShapeSelectionWidget(210, 113, 12, 13, ChiselingBlockShape.STAIRS, () -> this.selectedEntry, () -> this.changeShape(ChiselingBlockShape.STAIRS)));
        this.addWidget((Widget)new ShapeSelectionWidget(210, 127, 12, 13, ChiselingBlockShape.SLAB, () -> this.selectedEntry, () -> this.changeShape(ChiselingBlockShape.SLAB)));
        this.chiselAllWidget = (ChiselAllWidget)this.addWidget((Widget)new ChiselAllWidget(157, 109, 19, 21, () -> this.selectedEntry, this::chiselAll));
    }

    public void update() {
        this.updateRecipe();
        super.update();
    }

    public Component getNarrationMessage() {
        return this.title;
    }

    public void renderBackground(WidgetRenderContext context, int mouseX, int mouseY) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height);
        super.renderBackground(context, mouseX, mouseY);
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        super.render(context, mouseX, mouseY);
        for (int index = 1; index < ((BaseChiselingContainer)this.container).slots.size(); ++index) {
            Slot slot = ((BaseChiselingContainer)this.container).getSlot(index);
            ItemStack stack = slot.getItem();
            if (stack.isEmpty() || !stack.getComponentsPatch().isEmpty()) continue;
            if (this.recipe != null && this.recipe.contains((ItemLike)stack.getItem())) {
                ScreenUtils.fillRect((PoseStack)context.poseStack(), (float)(slot.x + 13), (float)slot.y, (float)3.0f, (float)3.0f, (float)0.14647888f, (float)0.30422536f, (float)0.48732394f, (float)0.5f);
                continue;
            }
            if (ChiselingRecipeManager.get(true).getRecipeForItem((ItemLike)stack.getItem()) == null) continue;
            ScreenUtils.fillRect((PoseStack)context.poseStack(), (float)(slot.x + 13), (float)slot.y, (float)3.0f, (float)3.0f, (float)1.0f, (float)0.5830986f, (float)0.2084507f, (float)0.5f);
        }
    }

    public void renderForeground(WidgetRenderContext context, int mouseX, int mouseY) {
        this.chiselAllWidget.chiselableItems = 0;
        if (this.recipe != null && this.chiselAllWidget.isFocused()) {
            boolean allShapes = Screen.hasShiftDown();
            int items = 0;
            for (int index = 1; index < ((BaseChiselingContainer)this.container).slots.size(); ++index) {
                boolean isChiselable;
                Slot slot = ((BaseChiselingContainer)this.container).getSlot(index);
                ItemStack stack = slot.getItem();
                if (stack.isEmpty() || !stack.getComponentsPatch().isEmpty() || stack.getItem() == this.selectedEntry.getItem(this.connecting).item()) continue;
                if (allShapes) {
                    isChiselable = this.recipe.contains((ItemLike)stack.getItem());
                } else {
                    isChiselable = false;
                    ChiselingBlockShape shape = this.selectedEntry.shape();
                    for (ChiselingEntry entry : this.recipe.entries()) {
                        if ((!entry.hasRegularItem(shape) || entry.getRegularItem(shape).item() != stack.getItem()) && (!entry.hasConnectingItem(shape) || entry.getConnectingItem(shape).item() != stack.getItem())) continue;
                        isChiselable = true;
                        break;
                    }
                }
                if (!isChiselable) continue;
                items += stack.getCount();
                ScreenUtils.fillRect((PoseStack)context.poseStack(), (float)slot.x, (float)slot.y, (float)16.0f, (float)16.0f, (float)0.0f, (float)20.0f, (float)100.0f, (float)0.5f);
            }
            this.chiselAllWidget.chiselableItems = items;
        }
        super.renderForeground(context, mouseX, mouseY);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)this.title, (float)51.0f, (float)2.0f, (int)0xE0E0E0);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)ClientUtils.getPlayer().getInventory().getName(), (float)50.0f, (float)150.0f);
    }

    private void updateDisplayEntries() {
        this.visibleEntries.clear();
        for (DisplayEntry entry : this.allEntries) {
            if (!this.matchesFilters(entry)) continue;
            this.visibleEntries.add(entry);
        }
        this.setScrollOffset(this.scrollOffset);
    }

    private void updateRecipe() {
        if (((BaseChiselingContainer)this.container).currentRecipe == null && this.recipe == null) {
            return;
        }
        if (((BaseChiselingContainer)this.container).currentRecipe != null && this.recipe == ((BaseChiselingContainer)this.container).currentRecipe) {
            if (this.lastContainerEntry != null && this.lastContainerEntry.entry() == ((BaseChiselingContainer)this.container).currentEntry && this.lastContainerEntry.shape() == ((BaseChiselingContainer)this.container).shape) {
                return;
            }
            if (this.selectedEntry != null && this.selectedEntry.entry() == ((BaseChiselingContainer)this.container).currentEntry && this.selectedEntry.shape() == ((BaseChiselingContainer)this.container).shape) {
                this.lastContainerEntry = new DisplayEntry(-1, ((BaseChiselingContainer)this.container).currentEntry, ((BaseChiselingContainer)this.container).shape);
                return;
            }
        }
        this.recipe = ((BaseChiselingContainer)this.container).currentRecipe;
        this.lastContainerEntry = new DisplayEntry(-1, ((BaseChiselingContainer)this.container).currentEntry, ((BaseChiselingContainer)this.container).shape);
        this.allEntries.clear();
        this.selectedEntry = null;
        this.connecting = false;
        this.searchField.setTextSuppressed("");
        searchText = "";
        formattedSearchText = "";
        this.searchField.setActive(this.recipe != null);
        this.filterOptionsWidget.setActive(this.recipe != null);
        DisplayEntry matchingDisplay = null;
        if (this.recipe != null) {
            Item currentItem = ((BaseChiselingContainer)this.container).getCurrentStack().getItem();
            for (ChiselingBlockShape shape : ChiselingBlockShape.values()) {
                for (int i = 0; i < this.recipe.entries().size(); ++i) {
                    ChiselingEntry entry = this.recipe.entries().get(i);
                    if (!entry.hasShape(shape)) continue;
                    DisplayEntry display = new DisplayEntry(i, entry, shape);
                    this.allEntries.add(display);
                    if (matchingDisplay != null || entry != ((BaseChiselingContainer)this.container).currentEntry) continue;
                    if (entry.hasRegularItem(shape) && entry.getRegularItem(shape).item() == currentItem) {
                        matchingDisplay = display;
                        this.connecting = false;
                        continue;
                    }
                    if (!entry.hasConnectingItem(shape) || entry.getConnectingItem(shape).item() != currentItem) continue;
                    matchingDisplay = display;
                    this.connecting = true;
                }
            }
        }
        this.updateDisplayEntries();
        if (matchingDisplay == null) {
            this.setScrollOffset(0.0f);
        } else {
            this.selectDisplayEntry(matchingDisplay);
        }
    }

    private boolean matchesFilters(DisplayEntry entry) {
        if (!showBlocks && entry.shape() == ChiselingBlockShape.BLOCK || !showStairs && entry.shape() == ChiselingBlockShape.STAIRS || !showSlabs && entry.shape() == ChiselingBlockShape.SLAB || !showNonConnecting && !entry.hasItem(true)) {
            return false;
        }
        return entry.hasItem(false) && this.doesItemMatchSearch(entry.getItem(false).item()) || entry.hasItem(true) && this.doesItemMatchSearch(entry.getItem(true).item());
    }

    private boolean doesItemMatchSearch(Item item) {
        boolean isModSearch;
        if (formattedSearchText.isEmpty()) {
            return true;
        }
        boolean bl = isModSearch = formattedSearchText.charAt(0) == '@';
        if (isModSearch) {
            if (formattedSearchText.length() == 1) {
                return true;
            }
            ResourceLocation identifier = BuiltInRegistries.ITEM.getKey((Object)item);
            if (identifier.getNamespace().toLowerCase().startsWith(formattedSearchText.substring(1))) {
                return true;
            }
            String modName = ModList.get().getModContainerById(identifier.getNamespace()).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(null);
            return modName != null && modName.toLowerCase().startsWith(formattedSearchText);
        }
        String name = TextComponents.item((Item)item).format();
        return name.toLowerCase().contains(formattedSearchText);
    }

    private DisplayEntry getDisplayEntry(int index) {
        return (index += this.scrollIndexOffset * 6) >= 0 && index < this.visibleEntries.size() ? this.visibleEntries.get(index) : null;
    }

    private void selectDisplayEntry(DisplayEntry entry) {
        int index;
        if (entry == null || this.selectedEntry == entry) {
            return;
        }
        boolean changedShape = this.selectedEntry == null || this.selectedEntry.shape() != entry.shape();
        boolean isSameRecipeEntry = this.selectedEntry != null && entry.entry() == this.selectedEntry.entry();
        this.selectedEntry = entry;
        if (!entry.hasItem(this.connecting)) {
            boolean bl = this.connecting = !this.connecting;
        }
        if (((BaseChiselingContainer)this.container).currentEntry != entry.entry() || ((BaseChiselingContainer)this.container).shape != entry.shape()) {
            Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketSelectEntry(entry.entryIndex(), entry.shape(), this.connecting));
        }
        if (filtersMatchShape && changedShape) {
            showBlocks = this.selectedEntry.shape() == ChiselingBlockShape.BLOCK;
            showStairs = this.selectedEntry.shape() == ChiselingBlockShape.STAIRS;
            showSlabs = this.selectedEntry.shape() == ChiselingBlockShape.SLAB;
            this.updateDisplayEntries();
        }
        if (!isSameRecipeEntry) {
            this.updateFiltersMatchShape(entry.shape());
        }
        if ((index = this.visibleEntries.indexOf(entry)) < 0) {
            return;
        }
        int row = index / 6;
        if ((float)row < this.scrollOffset || row + 1 > this.scrollIndexOffset + 5) {
            this.setScrollOffset(row - 2);
        }
    }

    private void toggleConnecting() {
        if (this.selectedEntry == null || !this.selectedEntry.hasItem(!this.connecting)) {
            return;
        }
        this.connecting = !this.connecting;
        Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketSelectEntry(this.selectedEntry.entryIndex(), this.selectedEntry.shape(), this.connecting));
    }

    private void changeShape(ChiselingBlockShape shape) {
        if (this.selectedEntry == null || this.selectedEntry.shape() == shape || !this.selectedEntry.entry().hasShape(shape)) {
            return;
        }
        for (DisplayEntry display : this.allEntries) {
            if (display.entry() != this.selectedEntry.entry() || display.shape() != shape) continue;
            this.selectDisplayEntry(display);
            break;
        }
        shape = this.selectedEntry.shape();
        if (filtersMatchShape) {
            showBlocks = shape == ChiselingBlockShape.BLOCK;
            showStairs = shape == ChiselingBlockShape.STAIRS;
            showSlabs = shape == ChiselingBlockShape.SLAB;
            this.updateDisplayEntries();
        }
    }

    private void toggleShowBlocks() {
        showBlocks = !showBlocks;
        this.updateFiltersMatchShape(this.selectedEntry.shape());
        this.updateDisplayEntries();
    }

    private void toggleShowStairs() {
        showStairs = !showStairs;
        this.updateFiltersMatchShape(this.selectedEntry.shape());
        this.updateDisplayEntries();
    }

    private void toggleShowSlabs() {
        showSlabs = !showSlabs;
        this.updateFiltersMatchShape(this.selectedEntry.shape());
        this.updateDisplayEntries();
    }

    private void toggleShowNonConnecting() {
        showNonConnecting = !showNonConnecting;
        this.updateDisplayEntries();
    }

    private void updateFiltersMatchShape(ChiselingBlockShape shape) {
        filtersMatchShape = shape == ChiselingBlockShape.BLOCK == showBlocks && shape == ChiselingBlockShape.STAIRS == showStairs && shape == ChiselingBlockShape.SLAB == showSlabs;
    }

    private void chiselAll() {
        Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketChiselAll(Screen.hasShiftDown()));
    }

    private void setScrollOffset(float offset) {
        int rows = (int)Math.ceil((float)this.visibleEntries.size() / 6.0f);
        this.scrollOffset = Math.max(0.0f, Math.min((float)(rows - 5), offset));
        this.scrollIndexOffset = (int)Math.floor(this.scrollOffset);
        for (EntryButtonWidget button : this.entryButtons) {
            button.setVerticalOffset(this.scrollOffset % 1.0f);
        }
    }

    public boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled) {
        if (!hasBeenHandled && mouseX > 8 && mouseX < 145 && mouseY > 33 && mouseY < 145) {
            this.setScrollOffset(this.scrollOffset - (float)scrollAmount / 3.0f);
            hasBeenHandled = true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled);
    }
}

