/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration.data;

import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.model.data.ConnectingModelDataBuilder;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.provider.FusionModelProvider;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.api.blocks.BlockModelType;
import com.supermartijn642.rechiseled.api.blocks.BlockSpecification;
import com.supermartijn642.rechiseled.blocks.RechiseledPillarBlock;
import com.supermartijn642.rechiseled.blocks.RechiseledSlabBlock;
import com.supermartijn642.rechiseled.blocks.RechiseledStairBlock;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.SlabType;

public class RegistrationFusionModelProvider
extends FusionModelProvider {
    private final RechiseledRegistrationImpl registration;

    public RegistrationFusionModelProvider(RechiseledRegistrationImpl registration, PackOutput output) {
        super(registration.getModid(), output);
        this.registration = registration;
    }

    protected void generate() {
        if (!this.registration.providersRegistered) {
            return;
        }
        this.registration.getBlockBuilders().forEach(builder -> {
            if (builder.hasConnectingVariant()) {
                Block block = builder.getConnectingBlock();
                boolean hasStairs = builder.hasStairs() && builder.getStairs().hasConnectingVariant();
                Block stairs = hasStairs ? builder.getStairs().getConnectingBlock() : null;
                boolean hasSlab = builder.hasSlabs() && builder.getSlabs().hasConnectingVariant();
                Block slab = builder.hasSlabs() && builder.getSlabs().hasConnectingVariant() ? builder.getSlabs().getConnectingBlock() : null;
                BlockModelType modelType = builder.getModelType() == null ? builder.getSpecification().getDefaultModelType() : builder.getModelType();
                String texture = builder.getIdentifier();
                this.addBlockModel(modelType, block, stairs, slab, texture);
                if (hasStairs) {
                    this.addStairsModels(modelType, block, stairs, slab, texture, builder.getSpecification());
                }
                if (hasSlab) {
                    this.addSlabModels(modelType, block, stairs, slab, texture);
                }
            }
        });
    }

    private void addBlockModel(BlockModelType modelType, Block block, Block stairs, Block slab, String texturePath) {
        ResourceLocation texture;
        ResourceLocation identifier = Registries.BLOCKS.getIdentifier((Object)block);
        ResourceLocation up = texture = identifier.withPath("block/" + texturePath);
        ResourceLocation down = texture;
        ResourceLocation north = texture;
        ResourceLocation east = texture;
        ResourceLocation south = texture;
        ResourceLocation west = texture;
        ResourceLocation particle = texture;
        if (modelType == BlockModelType.CUBE) {
            up = texture.withSuffix("_up");
            down = texture.withSuffix("_down");
            north = texture.withSuffix("_north");
            east = texture.withSuffix("_east");
            south = texture.withSuffix("_south");
            west = texture.withSuffix("_west");
            particle = up;
        } else if (modelType == BlockModelType.PILLAR) {
            up = down = texture.withSuffix("_end");
            south = west = texture.withSuffix("_side");
            east = west;
            particle = north = west;
        }
        ResourceLocation modelIdentifier = identifier.withPrefix("block/");
        this.addModel(modelIdentifier, ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"block/cube"))).texture("up", up)).texture("down", down)).texture("north", north)).texture("east", east)).texture("south", south)).texture("west", west)).texture("particle", particle)).connections("north", "side").connections("east", "side").connections("south", "side").connections("west", "side").connections("side", RegistrationFusionModelProvider.blockConnectionsSide(block, stairs, slab)).connections("up", RegistrationFusionModelProvider.blockConnectionsTop(block, stairs, slab)).connections("down", RegistrationFusionModelProvider.blockConnectionsBottom(block, stairs, slab)).build())));
        if (modelType == BlockModelType.PILLAR) {
            this.addModel(modelIdentifier.withSuffix("_horizontal"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(modelIdentifier)).connections("up", "all").connections("down", "all").connections("north", "all").connections("east", "all").connections("south", "all").connections("west", "all").connections("all", DefaultConnectionPredicates.isSameState()).build())));
        }
    }

    private void addStairsModels(BlockModelType modelType, Block block, Block stairs, Block slab, String texturePath, BlockSpecification specification) {
        ResourceLocation texture;
        ResourceLocation identifier = Registries.BLOCKS.getIdentifier((Object)stairs);
        ResourceLocation bottom = texture = identifier.withPath("block/" + texturePath);
        ResourceLocation side = texture;
        ResourceLocation top = texture;
        if (modelType == BlockModelType.CUBE) {
            throw new UnsupportedOperationException();
        }
        if (modelType == BlockModelType.PILLAR) {
            bottom = texture.withSuffix("_end");
            side = texture.withSuffix("_side");
            top = texture.withSuffix("_end");
        }
        ResourceLocation modelIdentifier = identifier.withPrefix("block/");
        ResourceLocation parent = specification == BlockSpecification.GLASS || specification == BlockSpecification.GLASS_PILLAR ? Rechiseled.identifier("block/glass_stairs") : ResourceLocation.withDefaultNamespace((String)"block/stairs");
        this.addModel(modelIdentifier.withSuffix("_bottom"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(parent)).texture("bottom", bottom)).texture("side", side)).texture("top", top)).connections("bottom", RegistrationFusionModelProvider.bottomStairConnectionsBottom(block, stairs, slab)).connections("side", RegistrationFusionModelProvider.bottomStairConnectionsSide(block, stairs, slab)).connections("top", RegistrationFusionModelProvider.bottomStairConnectionsTop(block, stairs, slab)).build())));
        parent = specification == BlockSpecification.GLASS || specification == BlockSpecification.GLASS_PILLAR ? Rechiseled.identifier("block/glass_inner_stairs") : ResourceLocation.withDefaultNamespace((String)"block/inner_stairs");
        this.addModel(modelIdentifier.withSuffix("_inner_bottom"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(parent)).texture("bottom", bottom)).texture("side", side)).texture("top", top)).connections("bottom", RegistrationFusionModelProvider.bottomStairConnectionsBottom(block, stairs, slab)).connections("side", RegistrationFusionModelProvider.bottomStairConnectionsSide(block, stairs, slab)).connections("top", RegistrationFusionModelProvider.bottomStairConnectionsTop(block, stairs, slab)).build())));
        parent = specification == BlockSpecification.GLASS || specification == BlockSpecification.GLASS_PILLAR ? Rechiseled.identifier("block/glass_outer_stairs") : ResourceLocation.withDefaultNamespace((String)"block/outer_stairs");
        this.addModel(modelIdentifier.withSuffix("_outer_bottom"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(parent)).texture("bottom", bottom)).texture("side", side)).texture("top", top)).connections("bottom", RegistrationFusionModelProvider.bottomStairConnectionsBottom(block, stairs, slab)).connections("side", RegistrationFusionModelProvider.bottomStairConnectionsSide(block, stairs, slab)).connections("top", RegistrationFusionModelProvider.bottomStairConnectionsTop(block, stairs, slab)).build())));
        parent = specification == BlockSpecification.GLASS || specification == BlockSpecification.GLASS_PILLAR ? Rechiseled.identifier("block/glass_stairs_top") : Rechiseled.identifier("block/stairs_top");
        this.addModel(modelIdentifier.withSuffix("_top"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(parent)).texture("bottom", bottom)).texture("side", side)).texture("top", top)).connections("bottom", RegistrationFusionModelProvider.topStairConnectionsBottom(block, stairs, slab)).connections("side", RegistrationFusionModelProvider.topStairConnectionsSide(block, stairs, slab)).connections("top", RegistrationFusionModelProvider.topStairConnectionsTop(block, stairs, slab)).build())));
        parent = specification == BlockSpecification.GLASS || specification == BlockSpecification.GLASS_PILLAR ? Rechiseled.identifier("block/glass_inner_stairs_top") : Rechiseled.identifier("block/inner_stairs_top");
        this.addModel(modelIdentifier.withSuffix("_inner_top"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(parent)).texture("bottom", bottom)).texture("side", side)).texture("top", top)).connections("bottom", RegistrationFusionModelProvider.topStairConnectionsBottom(block, stairs, slab)).connections("side", RegistrationFusionModelProvider.topStairConnectionsSide(block, stairs, slab)).connections("top", RegistrationFusionModelProvider.topStairConnectionsTop(block, stairs, slab)).build())));
        parent = specification == BlockSpecification.GLASS || specification == BlockSpecification.GLASS_PILLAR ? Rechiseled.identifier("block/glass_outer_stairs_top") : Rechiseled.identifier("block/outer_stairs_top");
        this.addModel(modelIdentifier.withSuffix("_outer_top"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(parent)).texture("bottom", bottom)).texture("side", side)).texture("top", top)).connections("bottom", RegistrationFusionModelProvider.topStairConnectionsBottom(block, stairs, slab)).connections("side", RegistrationFusionModelProvider.topStairConnectionsSide(block, stairs, slab)).connections("top", RegistrationFusionModelProvider.topStairConnectionsTop(block, stairs, slab)).build())));
    }

    private void addSlabModels(BlockModelType modelType, Block block, Block stairs, Block slab, String texturePath) {
        ResourceLocation texture;
        ResourceLocation identifier = Registries.BLOCKS.getIdentifier((Object)slab);
        ResourceLocation bottom = texture = identifier.withPath("block/" + texturePath);
        ResourceLocation side = texture;
        ResourceLocation top = texture;
        if (modelType == BlockModelType.CUBE) {
            throw new UnsupportedOperationException();
        }
        if (modelType == BlockModelType.PILLAR) {
            bottom = texture.withSuffix("_end");
            side = texture.withSuffix("_side");
            top = texture.withSuffix("_end");
        }
        ResourceLocation modelIdentifier = identifier.withPrefix("block/");
        this.addModel(modelIdentifier.withSuffix("_double"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"block/cube"))).texture("up", top)).texture("down", bottom)).texture("north", "#side")).texture("east", "#side")).texture("south", "#side")).texture("west", "#side")).texture("particle", "#side")).texture("side", side)).connections("north", "side").connections("east", "side").connections("south", "side").connections("west", "side").connections("side", RegistrationFusionModelProvider.blockConnectionsSide(block, stairs, slab)).connections("up", RegistrationFusionModelProvider.blockConnectionsTop(block, stairs, slab)).connections("down", RegistrationFusionModelProvider.blockConnectionsBottom(block, stairs, slab)).build())));
        this.addModel(modelIdentifier.withSuffix("_bottom"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"block/slab"))).texture("bottom", bottom)).texture("side", side)).texture("top", top)).connections("bottom", RegistrationFusionModelProvider.bottomSlabConnectionsBottom(block, stairs, slab)).connections("side", RegistrationFusionModelProvider.bottomSlabConnectionsSide(block, stairs, slab)).connections("top", RegistrationFusionModelProvider.bottomSlabConnectionsTop(block, stairs, slab)).build())));
        this.addModel(modelIdentifier.withSuffix("_top"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"block/slab_top"))).texture("bottom", bottom)).texture("side", side)).texture("top", top)).connections("bottom", RegistrationFusionModelProvider.topSlabConnectionsBottom(block, stairs, slab)).connections("side", RegistrationFusionModelProvider.topSlabConnectionsSide(block, stairs, slab)).connections("top", RegistrationFusionModelProvider.topSlabConnectionsTop(block, stairs, slab)).build())));
    }

    private static ConnectionPredicate isBlock(Block block) {
        if (block.getStateDefinition().getProperties().contains(RechiseledPillarBlock.AXIS_PROPERTY)) {
            return DefaultConnectionPredicates.matchState((Block)block, (Pair[])new Pair[]{Pair.of(RechiseledPillarBlock.AXIS_PROPERTY, (Object)Direction.Axis.Y)});
        }
        return DefaultConnectionPredicates.matchBlock((Block)block);
    }

    private static ConnectionPredicate isFullBlock(Block block, Block slab) {
        if (slab == null) {
            return RegistrationFusionModelProvider.isBlock(block);
        }
        return RegistrationFusionModelProvider.isBlock(block).or(new ConnectionPredicate[]{DefaultConnectionPredicates.matchState((Block)slab, (Pair[])new Pair[]{Pair.of(RechiseledSlabBlock.TYPE, (Object)SlabType.DOUBLE)})});
    }

    private static ConnectionPredicate isStairs(Block stairs) {
        return stairs == null ? DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[0]) : DefaultConnectionPredicates.matchBlock((Block)stairs);
    }

    private static ConnectionPredicate isTopStairs(Block stairs) {
        return stairs == null ? DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[0]) : DefaultConnectionPredicates.matchState((Block)stairs, (Pair[])new Pair[]{Pair.of(RechiseledStairBlock.HALF, (Object)Half.TOP)});
    }

    private static ConnectionPredicate isBottomStairs(Block stairs) {
        return stairs == null ? DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[0]) : DefaultConnectionPredicates.matchState((Block)stairs, (Pair[])new Pair[]{Pair.of(RechiseledStairBlock.HALF, (Object)Half.BOTTOM)});
    }

    private static ConnectionPredicate isSlab(Block slab) {
        return slab == null ? DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[0]) : DefaultConnectionPredicates.matchBlock((Block)slab);
    }

    private static ConnectionPredicate isTopSlab(Block slab) {
        return slab == null ? DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[0]) : DefaultConnectionPredicates.matchState((Block)slab, (Pair[])new Pair[]{Pair.of(RechiseledSlabBlock.TYPE, (Object)SlabType.TOP)});
    }

    private static ConnectionPredicate isBottomSlab(Block slab) {
        return slab == null ? DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[0]) : DefaultConnectionPredicates.matchState((Block)slab, (Pair[])new Pair[]{Pair.of(RechiseledSlabBlock.TYPE, (Object)SlabType.BOTTOM)});
    }

    private static ConnectionPredicate blockConnectionsSide(Block block, Block stairs, Block slab) {
        return DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[]{RegistrationFusionModelProvider.isFullBlock(block, slab), RegistrationFusionModelProvider.isStairs(stairs), DefaultConnectionPredicates.isDirection((ConnectionDirection[])new ConnectionDirection[]{ConnectionDirection.TOP, ConnectionDirection.TOP_LEFT, ConnectionDirection.TOP_RIGHT}).and(new ConnectionPredicate[]{RegistrationFusionModelProvider.isBottomSlab(slab)}), DefaultConnectionPredicates.isDirection((ConnectionDirection[])new ConnectionDirection[]{ConnectionDirection.BOTTOM, ConnectionDirection.BOTTOM_LEFT, ConnectionDirection.BOTTOM_RIGHT}).and(new ConnectionPredicate[]{RegistrationFusionModelProvider.isTopSlab(slab)})});
    }

    private static ConnectionPredicate blockConnectionsTop(Block block, Block stairs, Block slab) {
        return DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[]{RegistrationFusionModelProvider.isFullBlock(block, slab), RegistrationFusionModelProvider.isStairs(stairs), RegistrationFusionModelProvider.isTopSlab(slab)});
    }

    private static ConnectionPredicate blockConnectionsBottom(Block block, Block stairs, Block slab) {
        return DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[]{RegistrationFusionModelProvider.isFullBlock(block, slab), RegistrationFusionModelProvider.isStairs(stairs), RegistrationFusionModelProvider.isBottomSlab(slab)});
    }

    private static ConnectionPredicate bottomSlabConnectionsSide(Block block, Block stairs, Block slab) {
        return DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[]{DefaultConnectionPredicates.isDirection((ConnectionDirection[])new ConnectionDirection[]{ConnectionDirection.LEFT, ConnectionDirection.RIGHT}).and(new ConnectionPredicate[]{RegistrationFusionModelProvider.isBottomSlab(slab).or(new ConnectionPredicate[]{RegistrationFusionModelProvider.isBottomStairs(stairs)})}), DefaultConnectionPredicates.isDirection((ConnectionDirection[])new ConnectionDirection[]{ConnectionDirection.BOTTOM, ConnectionDirection.BOTTOM_LEFT, ConnectionDirection.BOTTOM_RIGHT}).and(new ConnectionPredicate[]{RegistrationFusionModelProvider.isFullBlock(block, slab).or(new ConnectionPredicate[]{RegistrationFusionModelProvider.isTopSlab(slab), RegistrationFusionModelProvider.isStairs(stairs)})})});
    }

    private static ConnectionPredicate bottomSlabConnectionsTop(Block block, Block stairs, Block slab) {
        return DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[]{RegistrationFusionModelProvider.isBottomSlab(slab), RegistrationFusionModelProvider.isBottomStairs(stairs)});
    }

    private static ConnectionPredicate bottomSlabConnectionsBottom(Block block, Block stairs, Block slab) {
        return RegistrationFusionModelProvider.blockConnectionsBottom(block, stairs, slab);
    }

    private static ConnectionPredicate topSlabConnectionsSide(Block block, Block stairs, Block slab) {
        return DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[]{DefaultConnectionPredicates.isDirection((ConnectionDirection[])new ConnectionDirection[]{ConnectionDirection.LEFT, ConnectionDirection.RIGHT}).and(new ConnectionPredicate[]{RegistrationFusionModelProvider.isTopSlab(slab).or(new ConnectionPredicate[]{RegistrationFusionModelProvider.isTopStairs(stairs)})}), DefaultConnectionPredicates.isDirection((ConnectionDirection[])new ConnectionDirection[]{ConnectionDirection.TOP, ConnectionDirection.TOP_LEFT, ConnectionDirection.TOP_RIGHT}).and(new ConnectionPredicate[]{RegistrationFusionModelProvider.isFullBlock(block, slab).or(new ConnectionPredicate[]{RegistrationFusionModelProvider.isBottomSlab(slab), RegistrationFusionModelProvider.isStairs(stairs)})})});
    }

    private static ConnectionPredicate topSlabConnectionsTop(Block block, Block stairs, Block slab) {
        return RegistrationFusionModelProvider.blockConnectionsTop(block, stairs, slab);
    }

    private static ConnectionPredicate topSlabConnectionsBottom(Block block, Block stairs, Block slab) {
        return DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[]{RegistrationFusionModelProvider.isTopSlab(slab), RegistrationFusionModelProvider.isTopStairs(stairs)});
    }

    private static ConnectionPredicate bottomStairConnectionsSide(Block block, Block stairs, Block slab) {
        return DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[]{RegistrationFusionModelProvider.isFullBlock(block, slab), RegistrationFusionModelProvider.isStairs(stairs), DefaultConnectionPredicates.isDirection((ConnectionDirection[])new ConnectionDirection[]{ConnectionDirection.LEFT, ConnectionDirection.TOP_LEFT, ConnectionDirection.TOP, ConnectionDirection.TOP_RIGHT, ConnectionDirection.RIGHT}).and(new ConnectionPredicate[]{RegistrationFusionModelProvider.isBottomSlab(slab)}), DefaultConnectionPredicates.isDirection((ConnectionDirection[])new ConnectionDirection[]{ConnectionDirection.BOTTOM, ConnectionDirection.BOTTOM_LEFT, ConnectionDirection.BOTTOM_RIGHT}).and(new ConnectionPredicate[]{RegistrationFusionModelProvider.isTopSlab(slab)})});
    }

    private static ConnectionPredicate bottomStairConnectionsTop(Block block, Block stairs, Block slab) {
        return DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[]{RegistrationFusionModelProvider.isBlock(block), RegistrationFusionModelProvider.isStairs(stairs), RegistrationFusionModelProvider.isSlab(slab)});
    }

    private static ConnectionPredicate bottomStairConnectionsBottom(Block block, Block stairs, Block slab) {
        return RegistrationFusionModelProvider.blockConnectionsBottom(block, stairs, slab);
    }

    private static ConnectionPredicate topStairConnectionsSide(Block block, Block stairs, Block slab) {
        return DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[]{RegistrationFusionModelProvider.isFullBlock(block, slab), RegistrationFusionModelProvider.isStairs(stairs), DefaultConnectionPredicates.isDirection((ConnectionDirection[])new ConnectionDirection[]{ConnectionDirection.TOP, ConnectionDirection.TOP_LEFT, ConnectionDirection.TOP_RIGHT}).and(new ConnectionPredicate[]{RegistrationFusionModelProvider.isBottomSlab(slab)}), DefaultConnectionPredicates.isDirection((ConnectionDirection[])new ConnectionDirection[]{ConnectionDirection.LEFT, ConnectionDirection.BOTTOM_LEFT, ConnectionDirection.BOTTOM, ConnectionDirection.BOTTOM_RIGHT, ConnectionDirection.RIGHT}).and(new ConnectionPredicate[]{RegistrationFusionModelProvider.isTopSlab(slab)})});
    }

    private static ConnectionPredicate topStairConnectionsTop(Block block, Block stairs, Block slab) {
        return RegistrationFusionModelProvider.blockConnectionsTop(block, stairs, slab);
    }

    private static ConnectionPredicate topStairConnectionsBottom(Block block, Block stairs, Block slab) {
        return RegistrationFusionModelProvider.bottomStairConnectionsTop(block, stairs, slab);
    }

    public String getName() {
        return "Registration Fusion Model Generator: " + this.registration.getModid();
    }
}

