/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration.data;

import com.supermartijn642.rechiseled.api.ChiselingRecipeProvider;
import com.supermartijn642.rechiseled.api.chiseling.data.ChiselingEntryBuilder;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class RegistrationChiselingRecipeProvider
extends ChiselingRecipeProvider {
    private final RechiseledRegistrationImpl registration;

    public RegistrationChiselingRecipeProvider(RechiseledRegistrationImpl registration, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(registration.getModid(), generator, existingFileHelper);
        this.registration = registration;
    }

    @Override
    protected void buildRecipes() {
        if (!this.registration.providersRegistered) {
            return;
        }
        this.registration.getChiselingEntries().forEach(recipe -> ((Consumer)recipe.right()).accept(this.beginRecipe((ResourceLocation)recipe.left()).entry()));
        this.registration.getBlockBuilders().forEach(builder -> {
            if (builder.getRecipe() != null) {
                ChiselingEntryBuilder entry = this.beginRecipe(builder.getRecipe()).entry();
                if (builder.getRegularBlock() != null) {
                    Block regularSlab;
                    Block regularStairs;
                    entry.regularBlock((ItemLike)builder.getRegularBlock());
                    Block block = regularStairs = builder.hasStairs() ? builder.getStairs().getRegularBlock() : null;
                    if (regularStairs != null) {
                        entry.regularStairs((ItemLike)regularStairs);
                    }
                    Block block2 = regularSlab = builder.hasSlabs() ? builder.getSlabs().getRegularBlock() : null;
                    if (regularSlab != null) {
                        entry.regularSlab((ItemLike)regularSlab);
                    }
                }
                if (builder.getConnectingBlock() != null) {
                    Block connectingSlab;
                    Block connectingStairs;
                    entry.connectingBlock((ItemLike)builder.getConnectingBlock());
                    Block block = connectingStairs = builder.hasStairs() ? builder.getStairs().getConnectingBlock() : null;
                    if (connectingStairs != null) {
                        entry.connectingStairs((ItemLike)connectingStairs);
                    }
                    Block block3 = connectingSlab = builder.hasSlabs() ? builder.getSlabs().getConnectingBlock() : null;
                    if (connectingSlab != null) {
                        entry.connectingSlab((ItemLike)connectingSlab);
                    }
                }
            }
        });
    }

    @Override
    public String getName() {
        return "Registration Chiseling Recipe Provider: " + this.registration.getModid();
    }
}

