/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.compat.rei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.CursorType;
import com.supermartijn642.core.gui.CursorTypes;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.rechiseled.Rechiseled;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class REIScrollableSlotsWidget
extends WidgetWithBounds
implements DraggableStackProviderWidget {
    private static final ResourceLocation SCROLLBAR_BACKGROUND = Rechiseled.identifier("textures/screen/rei_scrollbar_background.png");
    private static final ResourceLocation SCROLLER = Rechiseled.identifier("textures/screen/scroller.png");
    private static final int WIDTH = 178;
    private static final int HEIGHT = 72;
    private static final int BOX_WIDTH = 162;
    private static final int SCROLLBAR_WIDTH = 14;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int COLUMNS = 9;
    private static final int ROWS = 4;
    private static final int SLOT_WIDTH = 18;
    private static final int SLOT_HEIGHT = 18;
    private static final Widget SLOT_BACKGROUND = Widgets.createSlotBackground((Point)new Point(0, 0));
    private final int x;
    private final int y;
    private final Rectangle bounds;
    private final List<Slot> slots;
    private final int rows;
    private final boolean scrollable;
    private float scrollerPosition = 0.0f;
    private float targetPosition;
    private final float scrollerSpeed;
    private boolean dragging;

    public REIScrollableSlotsWidget(int x, int y, List<Slot> slots) {
        this.x = x;
        this.y = y;
        this.bounds = new Rectangle(this.x, this.y, 178, 72);
        this.slots = List.copyOf(slots);
        this.rows = Math.ceilDiv(slots.size(), 9);
        this.scrollable = this.rows > 4;
        this.scrollerSpeed = 0.1f;
    }

    private void setScrollTarget(float targetPosition) {
        this.targetPosition = Math.clamp(targetPosition, 0.0f, 1.0f);
    }

    private void tryScrollToTarget() {
        this.scrollerPosition = Math.clamp(this.targetPosition, this.scrollerPosition - this.scrollerSpeed, this.scrollerPosition + this.scrollerSpeed);
    }

    private void updateDrag(int mouseY) {
        this.setScrollTarget(((float)(mouseY - this.y - 1) - 7.5f) / 55.0f);
    }

    private float getRowOffset() {
        return this.scrollerPosition * (float)(this.rows - 4);
    }

    private <T> T getSlotMouseInteraction(int mouseX, int mouseY, SlotInteraction<T> interaction, T defaultValue) {
        if ((mouseX -= this.x) < 0 || mouseX > 162 || (mouseY -= this.y) < 0 || mouseY > 72) {
            return defaultValue;
        }
        int column = mouseX / 18;
        float rowOffset = this.getRowOffset();
        int row = (int)((float)mouseY / 18.0f + rowOffset);
        int index = column + row * 9;
        if (index >= this.slots.size()) {
            return defaultValue;
        }
        return interaction.perform(this.slots.get(index), mouseX - column * 18 - 1, (int)((float)mouseY - ((float)(mouseY / 18) + rowOffset % 1.0f) * 18.0f) - 1);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)this.x, (float)this.y, 0.0f);
        if (this.scrollable) {
            if (this.dragging) {
                this.updateDrag(mouseY);
                ScreenUtils.requestCursor((CursorType)CursorTypes.resizeVertical());
            } else if (mouseX > this.x + 162 + 2 && mouseX < this.x + 178 && mouseY > this.y && mouseY < this.y + 72) {
                ScreenUtils.requestCursor((CursorType)CursorTypes.pointingHand());
            }
            this.tryScrollToTarget();
        }
        ScreenUtils.bindTexture((ResourceLocation)SCROLLBAR_BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)pose, (float)164.0f, (float)0.0f, (float)14.0f, (float)72.0f);
        if (this.scrollable) {
            float y = 1.0f + this.scrollerPosition * 55.0f;
            boolean highlighted = this.dragging || mouseX > this.x + 162 + 2 && mouseX < this.x + 178 && mouseY > this.y && mouseY < this.y + 72;
            ScreenUtils.bindTexture((ResourceLocation)SCROLLER);
            ScreenUtils.drawTexture((PoseStack)pose, (float)165.0f, (float)y, (float)12.0f, (float)15.0f, (float)0.0f, (float)(highlighted ? 0.33333334f : 0.0f), (float)1.0f, (float)0.33333334f);
        } else {
            ScreenUtils.bindTexture((ResourceLocation)SCROLLER);
            ScreenUtils.drawTexture((PoseStack)pose, (float)165.0f, (float)1.0f, (float)12.0f, (float)15.0f, (float)0.0f, (float)0.6666667f, (float)1.0f, (float)0.33333334f);
        }
        try (CloseableScissors scissor = REIScrollableSlotsWidget.scissor((GuiGraphics)graphics, (Rectangle)new Rectangle(0, 0, 162, 72));){
            float rowOffset = this.getRowOffset();
            for (int row = 0; row < 5; ++row) {
                for (int column = 0; column < 9; ++column) {
                    pose.pushPose();
                    pose.translate((float)(column * 18 + 1), (float)(row * 18) - rowOffset % 1.0f * 18.0f + 1.0f, 0.0f);
                    int index = (row + (int)rowOffset) * 9 + column;
                    if (index < this.slots.size()) {
                        Slot slot = this.slots.get(index);
                        slot.render(graphics, mouseX - this.x - column * 18 - 1, (int)((float)(mouseY - this.y) - ((float)row - rowOffset % 1.0f) * 18.0f) - 1, partialTicks);
                    } else {
                        SLOT_BACKGROUND.render(graphics, 0, 0, partialTicks);
                    }
                    pose.popPose();
                }
            }
        }
        pose.popPose();
    }

    @Nullable
    public Tooltip getTooltip(TooltipContext context) {
        return this.getSlotMouseInteraction(context.getPoint().x, context.getPoint().y, (slot, relativeMouseX, relativeMouseY) -> slot.getTooltip(TooltipContext.of((Point)context.getPoint(), (Item.TooltipContext)context.vanillaContext(), (TooltipFlag)context.getFlag(), (boolean)context.isSearch())), null);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrollable && button == 0 && mouseX > (double)(this.x + 162 + 2) && mouseX < (double)(this.x + 178) && mouseY > (double)this.y && mouseY < (double)(this.y + 72)) {
            this.dragging = true;
            return true;
        }
        return this.getSlotMouseInteraction((int)mouseX, (int)mouseY, (slot, relativeMouseX, relativeMouseY) -> slot.mouseClicked((double)relativeMouseX, (double)relativeMouseY, button), false);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragging = false;
        }
        return this.getSlotMouseInteraction((int)mouseX, (int)mouseY, (slot, relativeMouseX, relativeMouseY) -> slot.mouseReleased((double)relativeMouseX, (double)relativeMouseY, button), false);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            return true;
        }
        return this.getSlotMouseInteraction((int)mouseX, (int)mouseY, (slot, relativeMouseX, relativeMouseY) -> slot.mouseDragged((double)relativeMouseX, (double)relativeMouseY, button, deltaX, deltaY), false);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (amountY == 0.0 || !this.scrollable) {
            return false;
        }
        if (mouseX > (double)(this.x + 2) && mouseX < (double)(this.x + 178) && mouseY > (double)this.y && mouseY < (double)(this.y + 72)) {
            this.setScrollTarget(this.targetPosition - 0.8f / (float)(this.rows - 4) * (float)amountY);
            return true;
        }
        return false;
    }

    @Nullable
    public DraggableStack getHoveredStack(DraggingContext<Screen> context, double mouseX, double mouseY) {
        return this.getSlotMouseInteraction((int)mouseX, (int)mouseY, (slot, relativeMouseX, relativeMouseY) -> slot instanceof DraggableStackProviderWidget ? ((DraggableStackProviderWidget)slot).getHoveredStack(context, (double)relativeMouseX, (double)relativeMouseY) : null, null);
    }

    public List<? extends GuiEventListener> children() {
        return List.of();
    }

    private static interface SlotInteraction<T> {
        public T perform(Slot var1, int var2, int var3);
    }
}

