/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.compat.rei;

import com.supermartijn642.rechiseled.api.chiseling.ChiselingBlockShape;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.compat.rei.ChiselingREIPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChiselingRecipeDisplay
implements Display {
    private final ChiselingRecipe recipe;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> outputs;

    public ChiselingRecipeDisplay(ChiselingRecipe recipe) {
        this.recipe = recipe;
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<EntryIngredient> outputs = new ArrayList<EntryIngredient>();
        for (ChiselingBlockShape shape : ChiselingBlockShape.values()) {
            for (ChiselingEntry entry : recipe.entries()) {
                ArrayList<ItemStack> output = new ArrayList<ItemStack>();
                if (entry.hasRegularItem(shape)) {
                    inputs.add(new ItemStack((ItemLike)entry.getRegularItem(shape).item()));
                    output.add(new ItemStack((ItemLike)entry.getRegularItem(shape).item()));
                }
                if (entry.hasConnectingItem(shape)) {
                    inputs.add(new ItemStack((ItemLike)entry.getConnectingItem(shape).item()));
                    output.add(new ItemStack((ItemLike)entry.getConnectingItem(shape).item()));
                }
                if (output.isEmpty()) continue;
                outputs.add(EntryIngredients.ofItemStacks(output));
            }
        }
        this.inputs = List.of(EntryIngredients.ofItemStacks(inputs));
        this.outputs = List.copyOf(outputs);
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ChiselingREIPlugin.CHISELING_CATEGORY;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.empty();
    }
}

