/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.compat.jei;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingBlockShape;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.api.chiseling.ItemWithWorth;
import com.supermartijn642.rechiseled.compat.jei.ChiselingJEIPlugin;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChiselingRecipeCategory
implements IRecipeCategory<ChiselingRecipe> {
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable focussedSlot;

    public ChiselingRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Rechiseled.chisel));
        this.arrow = guiHelper.drawableBuilder(Rechiseled.identifier("textures/screen/curved_arrow.png"), 0, 0, 20, 20).setTextureSize(20, 20).build();
        this.focussedSlot = guiHelper.drawableBuilder(Rechiseled.identifier("textures/screen/focussed_slot.png"), 0, 0, 18, 18).setTextureSize(18, 18).build();
    }

    public RecipeType<ChiselingRecipe> getRecipeType() {
        return ChiselingJEIPlugin.CHISELING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextComponents.translation((String)"rechiseled.recipe_category.title").get();
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 178;
    }

    public int getHeight() {
        return 94;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayoutBuilder, ChiselingRecipe recipe, IFocusGroup focuses) {
        Set<Item> focusedOutputs;
        ArrayList<Item> inputs = new ArrayList<Item>();
        ArrayList<List> outputs = new ArrayList<List>();
        for (ChiselingBlockShape shape : ChiselingBlockShape.values()) {
            for (ChiselingEntry entry : recipe.entries()) {
                ArrayList<Item> output = new ArrayList<Item>();
                if (entry.hasRegularItem(shape)) {
                    inputs.add(entry.getRegularItem(shape).item());
                    output.add(entry.getRegularItem(shape).item());
                }
                if (entry.hasConnectingItem(shape)) {
                    inputs.add(entry.getConnectingItem(shape).item());
                    output.add(entry.getConnectingItem(shape).item());
                }
                if (output.isEmpty()) continue;
                outputs.add(output);
            }
        }
        Set<Item> focusedInputs = ChiselingRecipeCategory.focusedItems(focuses, RecipeIngredientRole.INPUT);
        if (!focusedInputs.isEmpty()) {
            inputs.sort(Comparator.comparing(item -> !focusedInputs.contains(item)));
        }
        if (!(focusedOutputs = ChiselingRecipeCategory.focusedItems(focuses, RecipeIngredientRole.OUTPUT)).isEmpty()) {
            outputs.sort(Comparator.comparing(stacks -> stacks.stream().noneMatch(focusedOutputs::contains)));
        }
        IRecipeSlotRichTooltipCallback tooltip = (slot, builder) -> {
            float worth = slot.getDisplayedItemStack().map(stack -> recipe.getWorth((ItemLike)stack.getItem())).map(ItemWithWorth::worth).orElse(Float.valueOf(1.0f)).floatValue();
            if (worth != 1.0f) {
                worth = (float)Math.round(worth * 1000.0f) / 1000.0f;
                builder.add((FormattedText)TextComponents.translation((String)"rechiseled.recipe_category.conversion_value", (Object[])new Object[]{TextComponents.number((double)worth).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get());
            }
        };
        IRecipeSlotBuilder input = recipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 1, 28).addRichTooltipCallback(tooltip);
        inputs.forEach(arg_0 -> ((IRecipeSlotBuilder)input).addItemLike(arg_0));
        if (inputs.stream().anyMatch(focusedInputs::contains)) {
            input.setBackground(this.focussedSlot, -1, -1);
        } else {
            input.setStandardSlotBackground();
        }
        for (int i = 0; i < outputs.size(); ++i) {
            int x = 49 + 18 * (i % 7);
            int y = 1 + 18 * (i / 7);
            List items = (List)outputs.get(i);
            IRecipeSlotBuilder output = recipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addRichTooltipCallback(tooltip);
            items.forEach(arg_0 -> ((IRecipeSlotBuilder)output).addItemLike(arg_0));
            if (!items.stream().anyMatch(focusedOutputs::contains)) continue;
            output.setBackground(this.focussedSlot, -1, -1);
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, ChiselingRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotDrawable)builder.getRecipeSlots().getSlots(RecipeIngredientRole.INPUT).getFirst()).setPosition(73, 1);
        builder.addScrollGridWidget(builder.getRecipeSlots().getSlots(RecipeIngredientRole.OUTPUT), 9, 4).setPosition(0, 22);
        builder.addDrawable(this.arrow).setPosition(89, 0);
    }

    private static Set<Item> focusedItems(IFocusGroup focuses, RecipeIngredientRole role) {
        return focuses.getItemStackFocuses(role).map(IFocus::getTypedValue).map(ITypedIngredient::getItemStack).filter(Optional::isPresent).map(Optional::get).map(ItemStack::getItem).collect(Collectors.toSet());
    }
}

