/*
 * Decompiled with CFR 0.152.
 */
package io.github.lieonlion.mcv.block;

import io.github.lieonlion.mcv.block.MoreChestBlock;
import io.github.lieonlion.mcv.block.entity.MoreTrappedChestBlockEntity;
import io.github.lieonlion.mcv.init.McvBlockInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class MoreTrappedChestBlock
extends MoreChestBlock {
    public final String chestType;

    public MoreTrappedChestBlock(MapColor colour, String chestType) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHEST).mapColor(colour), () -> McvBlockInit.MORE_TRAPPED_CHEST_BLOCK_ENTITY.get(), chestType);
        this.chestType = chestType;
    }

    public MoreTrappedChestBlock(MapColor colour, SoundType sound, String chestType) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHEST).mapColor(colour).sound(sound), () -> McvBlockInit.MORE_TRAPPED_CHEST_BLOCK_ENTITY.get(), chestType);
        this.chestType = chestType;
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.CUSTOM.get((Object)Stats.TRIGGER_TRAPPED_CHEST);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        return Mth.clamp((int)ChestBlockEntity.getOpenCount((BlockGetter)getter, (BlockPos)pos), (int)0, (int)15);
    }

    public int getDirectSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        return direction == Direction.UP ? state.getSignal(getter, pos, direction) : 0;
    }

    @Override
    @NotNull
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MoreTrappedChestBlockEntity(pos, state);
    }
}

