/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.api;

import com.github.talrey.createdeco.BlockStateGenerator;
import com.github.talrey.createdeco.CreateDecoMod;
import com.github.talrey.createdeco.api.CreateDecoTags;
import com.github.talrey.createdeco.blocks.CageLampBlock;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CageLamps {
    public static final ResourceLocation YELLOW_ON = CreateDecoMod.id("block/palettes/cage_lamp/light_default");
    public static final ResourceLocation YELLOW_OFF = CreateDecoMod.id("block/palettes/cage_lamp/light_default_off");
    public static final ResourceLocation RED_ON = CreateDecoMod.id("block/palettes/cage_lamp/light_redstone");
    public static final ResourceLocation RED_OFF = CreateDecoMod.id("block/palettes/cage_lamp/light_redstone_off");
    public static final ResourceLocation GREEN_ON = CreateDecoMod.id("block/palettes/cage_lamp/light_green");
    public static final ResourceLocation GREEN_OFF = CreateDecoMod.id("block/palettes/cage_lamp/light_green_off");
    public static final ResourceLocation BLUE_ON = CreateDecoMod.id("block/palettes/cage_lamp/light_soul");
    public static final ResourceLocation BLUE_OFF = CreateDecoMod.id("block/palettes/cage_lamp/light_soul_off");

    private static ShapedRecipeBuilder cageLampRecipeBuilder(ItemLike item, Supplier<Item> light) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)item).pattern("n").pattern("t").pattern("p").define(Character.valueOf('t'), (ItemLike)light.get());
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateRecipeProvider> recipe(String metal, Supplier<Item> light) {
        return CageLamps.recipe(metal, light, null);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateRecipeProvider> recipe(String metalName, Supplier<Item> light, @Nullable Supplier<Item> nonstandardMaterial) {
        String metal = metalName.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        return (ctx, prov) -> {
            if (nonstandardMaterial != null) {
                CageLamps.cageLampRecipeBuilder((ItemLike)ctx.get(), light).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)nonstandardMaterial.get()})).define(Character.valueOf('n'), (ItemLike)nonstandardMaterial.get()).define(Character.valueOf('p'), CreateDecoTags.plate(metalName)).save((RecipeOutput)prov);
            } else {
                CageLamps.cageLampRecipeBuilder((ItemLike)ctx.get(), light).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(CreateDecoTags.plate(metalName)).build()})).define(Character.valueOf('n'), CreateDecoTags.nugget(metalName)).define(Character.valueOf('p'), CreateDecoTags.plate(metalName)).save((RecipeOutput)prov);
            }
        };
    }

    public static BlockBuilder<CageLampBlock, ?> build(CreateRegistrate reg, String name, DyeColor color, ResourceLocation cage, ResourceLocation lampOn, ResourceLocation lampOff) {
        return reg.block(color.getName().toLowerCase(Locale.ROOT) + "_" + name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_lamp", p -> new CageLampBlock((BlockBehaviour.Properties)p, new Vector3f(0.3f, 0.3f, 0.0f))).properties(props -> props.noOcclusion().strength(0.5f).sound(SoundType.LANTERN).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 0)).blockstate((ctx, prov) -> BlockStateGenerator.cageLamp(cage, lampOn, lampOff, ctx, prov)).addLayer(() -> RenderType::cutoutMipped).lang(color.name().charAt(0) + color.name().substring(1).toLowerCase() + " " + name + " Cage Lamp").simpleItem();
    }
}

