/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumdynamiclights.mixin;

import dev.lambdaurora.lambdynlights.api.DynamicLightHandler;
import java.util.HashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import toni.sodiumdynamiclights.SodiumDynamicLights;
import toni.sodiumdynamiclights.accessor.DynamicLightHandlerHolder;

@Mixin(value={EntityType.class})
public abstract class EntityTypeMixin<T extends Entity>
implements DynamicLightHandlerHolder<T> {
    @Unique
    private DynamicLightHandler<T> sodiumdynamiclights$lightHandler;
    @Unique
    private Boolean sodiumdynamiclights$setting;

    @Shadow
    public abstract Component getDescription();

    @Override
    @Nullable
    public DynamicLightHandler<T> sodiumdynamiclights$getDynamicLightHandler() {
        return this.sodiumdynamiclights$lightHandler;
    }

    @Override
    public void sodiumdynamiclights$setDynamicLightHandler(DynamicLightHandler<T> handler) {
        this.sodiumdynamiclights$lightHandler = handler;
    }

    @Override
    public boolean sodiumdynamiclights$getSetting() {
        if (this.sodiumdynamiclights$setting == null) {
            EntityType self = (EntityType)this;
            ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)self);
            if (id.getNamespace().equals("minecraft") && id.getPath().equals("pig") && self != EntityType.PIG) {
                return false;
            }
            String path = "light_sources.settings.entities." + id.getNamespace() + "." + id.getPath().replace('/', '.');
            HashMap<String, Boolean> config = SodiumDynamicLights.get().config.getLightSettings();
            if (!config.containsKey(path)) {
                this.sodiumdynamiclights$setting = false;
                return false;
            }
            this.sodiumdynamiclights$setting = config.getOrDefault(path, false);
        }
        return this.sodiumdynamiclights$setting;
    }

    @Override
    public Component sodiumdynamiclights$getName() {
        Component name = this.getDescription();
        if (name == null) {
            return Component.translatable((String)"sodiumdynamiclights.dummy");
        }
        return name;
    }
}

