/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.platform;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.catalogue.Constants;
import com.mrcrayfish.catalogue.client.IModData;
import com.mrcrayfish.catalogue.client.NeoForgeModData;
import com.mrcrayfish.catalogue.platform.services.IPlatformHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforgespi.language.IModFileInfo;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public boolean isForge() {
        return true;
    }

    @Override
    public List<IModData> getAllModData() {
        return ModList.get().getMods().stream().map(NeoForgeModData::new).collect(Collectors.toList());
    }

    @Override
    public File getModDirectory() {
        return FMLPaths.MODSDIR.get().toFile();
    }

    @Override
    public Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public void loadNativeImage(String modId, String resource, Consumer<NativeImage> consumer) {
        try {
            NativeImage image = null;
            IModFileInfo info = ModList.get().getModFileById(modId);
            Path path = info.getFile().findResource(new String[]{resource});
            if (Files.exists(path, new LinkOption[0])) {
                image = NativeImage.read((InputStream)Files.newInputStream(path, new OpenOption[0]));
            }
            Optional.ofNullable(image).ifPresent(consumer);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to load image resource {}:file/{}", new Object[]{modId, resource, e});
        }
    }

    @Override
    public boolean isCustomItemRendering(Item item) {
        return IClientItemExtensions.of((Item)item).getCustomRenderer() != Minecraft.getInstance().getItemRenderer().getBlockEntityRenderer();
    }

    @Override
    public void drawUpdateIcon(GuiGraphics graphics, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(NeoForgeModData.VERSION_CHECK_ICONS, x, y, 24.0f, 0.0f, 8, 8, 64, 16);
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }
}

