/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client.screen.widget;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.catalogue.client.screen.DropdownMenuHandler;
import com.mrcrayfish.catalogue.client.screen.layout.BorderedLinearLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class DropdownMenu
extends AbstractWidget {
    private final DropdownMenuHandler handler;
    private final BorderedLinearLayout layout = (BorderedLinearLayout)BorderedLinearLayout.vertical().border(1).spacing(1);
    private final List<AbstractWidget> items = new ArrayList<AbstractWidget>();
    private Alignment alignment = Alignment.BELOW_LEFT;
    @Nullable
    private DropdownMenu parent;
    @Nullable
    private DropdownMenu subMenu;

    private DropdownMenu(DropdownMenuHandler handler) {
        super(0, 0, 0, 0, CommonComponents.EMPTY);
        this.handler = handler;
        this.visible = false;
    }

    private void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public void toggle(int mouseX, int mouseY) {
        this.toggle(new ScreenRectangle(mouseX, mouseY, 0, 0));
    }

    public void toggle(AbstractWidget widget) {
        this.toggle(widget.getRectangle());
    }

    public void toggle(ScreenRectangle rect) {
        if (!this.visible) {
            this.show(rect);
        } else {
            this.hide();
        }
    }

    private void show(ScreenRectangle rect) {
        this.updatePosition(rect);
        this.items.forEach(child -> {
            child.visible = true;
        });
        this.visible = true;
        if (this.parent == null) {
            this.handler.setMenu(this);
        }
    }

    public void hide() {
        this.items.forEach(child -> {
            child.visible = false;
            if (child instanceof DropdownItem) {
                DropdownItem menu = (DropdownItem)((Object)child);
                menu.subMenu.hide();
            }
        });
        this.subMenu = null;
        this.visible = false;
    }

    private void updatePosition(ScreenRectangle rect) {
        this.layout.arrangeElements();
        this.width = this.layout.getWidth();
        this.height = this.layout.getHeight();
        this.alignment.aligner.accept(this, rect);
        this.layout.setX(this.getX());
        this.layout.setY(this.getY());
    }

    public void addItem(MenuItem item) {
        this.layout.addChild((LayoutElement)item);
        this.items.add(item);
        item.visible = false;
    }

    private void deepClose() {
        this.handler.setMenu(null);
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 50.0f);
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        graphics.fill(0, 0, window.getWidth(), window.getHeight(), 0x50000000);
        graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -1442840576);
        this.items.forEach(widget -> widget.render(graphics, mouseX, mouseY, deltaTick));
        if (this.subMenu != null) {
            this.subMenu.render(graphics, mouseX, mouseY, deltaTick);
        }
        poseStack.popPose();
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.active || !this.visible) {
            return false;
        }
        AtomicBoolean clicked = new AtomicBoolean();
        this.layout.visitWidgets(widget -> {
            if (widget.mouseClicked(mouseX, mouseY, button)) {
                clicked.set(true);
            }
        });
        return clicked.get();
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
        this.layout.visitWidgets(consumer);
    }

    public static Builder builder(DropdownMenuHandler handler) {
        return new Builder(handler);
    }

    public static enum Alignment {
        ABOVE_LEFT((menu, rectangle) -> {
            menu.setX(rectangle.left());
            menu.setY(rectangle.top() - menu.getHeight());
        }),
        ABOVE_RIGHT((menu, rectangle) -> {
            menu.setX(rectangle.right() - menu.getWidth());
            menu.setY(rectangle.top() - menu.getHeight());
        }),
        BELOW_LEFT((menu, rectangle) -> {
            menu.setX(rectangle.left() - 1);
            menu.setY(rectangle.bottom());
        }),
        BELOW_RIGHT((menu, rectangle) -> {
            menu.setX(rectangle.right() - menu.getWidth() + 1);
            menu.setY(rectangle.bottom());
        }),
        END_TOP((menu, rectangle) -> {
            menu.setX(rectangle.right());
            menu.setY(rectangle.top() - 1);
        }),
        END_BOTTOM((menu, rectangle) -> {
            menu.setX(rectangle.right());
            menu.setY(rectangle.bottom() - menu.getHeight() + 1);
        });

        private final MenuAligner aligner;

        private Alignment(MenuAligner positioner) {
            this.aligner = positioner;
        }
    }

    private static interface MenuAligner {
        public void accept(DropdownMenu var1, ScreenRectangle var2);
    }

    public static class MenuItem
    extends AbstractWidget {
        protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"catalogue", (String)"dropdown/item"), ResourceLocation.fromNamespaceAndPath((String)"catalogue", (String)"dropdown/item_highlighted"));
        protected final DropdownMenu parent;
        private final Runnable onClick;

        public MenuItem(DropdownMenu menu, Component label, Runnable onClick) {
            super(0, 0, 100, 20, label);
            this.parent = menu;
            this.onClick = onClick;
        }

        protected boolean selected() {
            return false;
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
            RenderSystem.enableBlend();
            graphics.blitSprite(SPRITES.get(this.active, this.isHovered() || this.selected()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            RenderSystem.disableBlend();
            Font font = Minecraft.getInstance().font;
            int n = this.getHeight();
            Objects.requireNonNull(font);
            int offset = (n - 9) / 2 + 1;
            graphics.drawString(Minecraft.getInstance().font, this.getMessage(), this.getX() + offset, this.getY() + offset, -1);
        }

        public void onClick(double mouseX, double mouseY) {
            this.onClick.run();
            this.parent.deepClose();
        }

        protected void updateWidgetNarration(NarrationElementOutput output) {
            output.add(NarratedElementType.TITLE, this.getMessage());
        }

        protected int calculateWidth() {
            Font font = Minecraft.getInstance().font;
            int n = this.getHeight();
            Objects.requireNonNull(font);
            int labelOffset = (n - 9) / 2 + 1;
            int labelWidth = font.width((FormattedText)this.getMessage());
            return labelOffset + labelWidth + labelOffset;
        }
    }

    public static class Builder {
        private final DropdownMenuHandler handler;
        private final DropdownMenu base;
        private final List<MenuItem> items = new ArrayList<MenuItem>();
        private int minItemWidth = 0;
        private int minItemHeight = 20;

        private Builder(DropdownMenuHandler handler) {
            this.handler = handler;
            this.base = new DropdownMenu(handler);
        }

        public Builder setMinItemSize(int width, int height) {
            this.minItemWidth = width;
            this.minItemHeight = height;
            return this;
        }

        public Builder setAlignment(Alignment alignment) {
            this.base.setAlignment(alignment);
            return this;
        }

        public Builder addItem(Component label, Runnable onClick) {
            this.items.add(new MenuItem(this.base, label, onClick));
            return this;
        }

        public Builder addCheckbox(Component label, MutableBoolean holder, Function<Boolean, Boolean> callback) {
            this.items.add(new CheckboxMenuItem(this.base, label, holder, callback));
            return this;
        }

        public Builder addMenu(Component label, Builder builder) {
            DropdownMenu menu = builder.build();
            menu.parent = this.base;
            this.items.add(new DropdownItem(this.base, menu, label));
            return this;
        }

        public DropdownMenu build() {
            int maxWidth = this.items.stream().mapToInt(MenuItem::calculateWidth).max().orElse(100);
            this.items.forEach(widget -> {
                widget.setSize(Math.max(maxWidth, this.minItemWidth), this.minItemHeight);
                this.base.addItem((MenuItem)((Object)widget));
            });
            return this.base;
        }
    }

    private static class DropdownItem
    extends MenuItem {
        private final DropdownMenu subMenu;

        public DropdownItem(DropdownMenu menu, DropdownMenu subMenu, Component label) {
            super(menu, label, () -> {});
            this.subMenu = subMenu;
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            if (this.selected()) {
                poseStack.translate(0.0f, 0.0f, 51.0f);
            }
            super.renderWidget(graphics, mouseX, mouseY, deltaTick);
            Font font = Minecraft.getInstance().font;
            int n = this.getY();
            int n2 = this.getHeight();
            Objects.requireNonNull(font);
            int top = n + (n2 - 9) / 2 + 1;
            graphics.drawString(Minecraft.getInstance().font, ">", this.getX() + this.getWidth() - 10, top, -1);
            poseStack.popPose();
        }

        @Override
        public void onClick(double mouseX, double mouseY) {
            if (this.parent.subMenu != null) {
                this.parent.subMenu.hide();
                if (this.parent.subMenu == this.subMenu) {
                    this.parent.subMenu = null;
                    return;
                }
            }
            this.parent.subMenu = this.subMenu;
            this.subMenu.show(this.getRectangle());
        }

        public void visitWidgets(Consumer<AbstractWidget> consumer) {
            consumer.accept(this);
            this.subMenu.visitWidgets(consumer);
        }

        @Override
        protected boolean selected() {
            return this.parent.subMenu == this.subMenu;
        }

        @Override
        protected int calculateWidth() {
            Font font = Minecraft.getInstance().font;
            int n = this.getHeight();
            Objects.requireNonNull(font);
            int labelOffset = (n - 9) / 2 + 1;
            int labelWidth = font.width((FormattedText)this.getMessage());
            int arrowWidth = font.width(">");
            return labelOffset + labelWidth + labelOffset + arrowWidth + labelOffset;
        }
    }

    private static class CheckboxMenuItem
    extends MenuItem {
        private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"catalogue", (String)"textures/gui/checkbox.png");
        private final MutableBoolean holder;
        private final Function<Boolean, Boolean> callback;

        public CheckboxMenuItem(DropdownMenu menu, Component label, MutableBoolean holder, Function<Boolean, Boolean> callback) {
            super(menu, label, () -> {});
            this.holder = holder;
            this.callback = callback;
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float deltaTick) {
            super.renderWidget(graphics, mouseX, mouseY, deltaTick);
            int offset = (this.getHeight() - 14) / 2;
            graphics.blit(TEXTURE, this.getX() + this.getWidth() - 14 - offset, this.getY() + offset, this.isHoveredOrFocused() ? 14.0f : 0.0f, this.holder.getValue() != false ? 14.0f : 0.0f, 14, 14, 64, 64);
        }

        @Override
        public void onClick(double mouseX, double mouseY) {
            boolean newValue = this.holder.getValue() == false;
            this.holder.setValue(newValue);
            if (this.callback.apply(newValue).booleanValue()) {
                this.parent.deepClose();
            }
        }

        @Override
        protected int calculateWidth() {
            Font font = Minecraft.getInstance().font;
            int n = this.getHeight();
            Objects.requireNonNull(font);
            int labelOffset = (n - 9) / 2 + 1;
            int labelWidth = font.width((FormattedText)this.getMessage());
            int checkboxOffset = (this.getHeight() - 14) / 2;
            return labelOffset + labelWidth + labelOffset + 14 + checkboxOffset;
        }
    }
}

