/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CatalogueIconButton
extends Button {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"catalogue", (String)"textures/gui/icons.png");
    private final Component label;
    private final int u;
    private final int v;

    public CatalogueIconButton(int x, int y, int u, int v, Button.OnPress onPress) {
        this(x, y, u, v, 20, CommonComponents.EMPTY, onPress);
    }

    public CatalogueIconButton(int x, int y, int u, int v, int width, int height, Button.OnPress onPress) {
        this(x, y, u, v, width, height, CommonComponents.EMPTY, onPress);
    }

    public CatalogueIconButton(int x, int y, int u, int v, int width, Component label, Button.OnPress onPress) {
        this(x, y, u, v, width, 20, label, onPress);
    }

    public CatalogueIconButton(int x, int y, int u, int v, int width, int height, Component label, Button.OnPress onPress) {
        super(x, y, width, height, CommonComponents.EMPTY, onPress, Button.DEFAULT_NARRATION);
        this.label = label;
        this.u = u;
        this.v = v;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int contentWidth = 10 + minecraft.font.width((FormattedText)this.label) + (!this.label.getString().isEmpty() ? 4 : 0);
        int iconX = this.getX() + (this.width - contentWidth) / 2;
        int iconY = this.getY() + (this.height - 10) / 2;
        float brightness = this.active ? 1.0f : 0.5f;
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)this.alpha);
        graphics.blit(TEXTURE, iconX, iconY, (float)this.u, (float)this.v, 10, 10, 64, 64);
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)this.alpha);
        int textColor = 0xFFFFFF | Mth.ceil((float)(this.alpha * 255.0f)) << 24;
        graphics.drawString(minecraft.font, this.label, iconX + 14, iconY + 1, textColor);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, (Component)this.createNarration.createNarrationMessage(() -> CatalogueIconButton.wrapDefaultNarrationMessage((Component)this.label)));
        if (this.active) {
            if (this.isFocused()) {
                output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.button.usage.focused"));
            } else {
                output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.button.usage.hovered"));
            }
        }
    }
}

