/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.unify.register;

import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.lopyluna.unify.Unify;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class AllTags {
    public static void addGenerators() {
        Unify.REG.generateTags();
    }

    public static void genBlockTags(RegistrateTagsProvider<Block> provIn) {
        TagsProvider<Block> prov = new TagsProvider<Block>(provIn, Block::builtInRegistryHolder);
    }

    public static void genItemTags(RegistrateTagsProvider<Item> provIn) {
        TagsProvider<Item> prov = new TagsProvider<Item>(provIn, Item::builtInRegistryHolder);
    }

    public static TagKey<Block> block(String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Unify.loc(name));
    }

    public static TagKey<Block> blockC(String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public static TagKey<Block> blockMC(String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name));
    }

    public static TagKey<Item> item(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Unify.loc(name));
    }

    public static TagKey<Item> itemC(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public static TagKey<Item> itemMC(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name));
    }

    public static class TagsProvider<T> {
        private final RegistrateTagsProvider<T> provider;
        private final Function<T, ResourceKey<T>> keyExtractor;

        public TagsProvider(RegistrateTagsProvider<T> provider, Function<T, Holder.Reference<T>> refExtractor) {
            this.provider = provider;
            this.keyExtractor = refExtractor.andThen(Holder.Reference::key);
        }

        public TagAppender<T> tag(TagKey<T> tag) {
            TagBuilder tagbuilder = this.getOrCreateRawBuilder(tag);
            return new TagAppender<T>(tagbuilder, this.keyExtractor);
        }

        public TagBuilder getOrCreateRawBuilder(TagKey<T> tag) {
            return this.provider.addTag(tag).getInternalBuilder();
        }
    }

    public static class TagAppender<T>
    extends TagsProvider.TagAppender<T> {
        private final Function<T, ResourceKey<T>> keyExtractor;

        public TagAppender(TagBuilder pBuilder, Function<T, ResourceKey<T>> pKeyExtractor) {
            super(pBuilder);
            this.keyExtractor = pKeyExtractor;
        }

        public TagAppender<T> add(T entry) {
            this.add(this.keyExtractor.apply(entry));
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> add(T ... entries) {
            Stream.of(entries).map(this.keyExtractor).forEach(arg_0 -> ((TagAppender)this).add(arg_0));
            return this;
        }
    }
}

