/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.unify.register;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.lopyluna.unify.Unify;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.DeferredSoundType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

public class AllSoundEvents {
    public static final Map<ResourceLocation, SoundEntry> ALL = new HashMap<ResourceLocation, SoundEntry>();
    public static SoundType METAL_HEAVY = new DeferredSoundType(0.9f, 0.5f, () -> SoundEvents.POLISHED_DEEPSLATE_BREAK, () -> SoundEvents.POLISHED_DEEPSLATE_STEP, () -> SoundEvents.POLISHED_DEEPSLATE_PLACE, () -> SoundEvents.POLISHED_DEEPSLATE_HIT, () -> SoundEvents.POLISHED_DEEPSLATE_FALL);
    public static SoundType NETHERITE_HEAVY = new DeferredSoundType(0.9f, 0.5f, () -> SoundEvents.NETHERITE_BLOCK_BREAK, () -> SoundEvents.NETHERITE_BLOCK_STEP, () -> SoundEvents.NETHERITE_BLOCK_PLACE, () -> SoundEvents.NETHERITE_BLOCK_HIT, () -> SoundEvents.NETHERITE_BLOCK_FALL);
    public static SoundType COPPER_HEAVY = new DeferredSoundType(0.9f, 0.5f, () -> SoundEvents.COPPER_BREAK, () -> SoundEvents.COPPER_STEP, () -> SoundEvents.COPPER_PLACE, () -> SoundEvents.COPPER_HIT, () -> SoundEvents.COPPER_FALL);

    private static SoundEntryBuilder create(String name) {
        return AllSoundEvents.create(Unify.loc(name));
    }

    public static SoundEntryBuilder create(ResourceLocation id) {
        return new SoundEntryBuilder(id);
    }

    public static void prepare() {
        for (SoundEntry entry : ALL.values()) {
            entry.prepare();
        }
    }

    public static void register(RegisterEvent event) {
        event.register(Registries.SOUND_EVENT, helper -> ALL.values().forEach(entry -> entry.register((RegisterEvent.RegisterHelper<SoundEvent>)helper)));
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (SoundEntry entry : ALL.values()) {
            if (!entry.hasSubtitle()) continue;
            consumer.accept(entry.getSubtitleKey(), entry.getSubtitle());
        }
    }

    public static SoundEntryProvider provider(DataGenerator generator) {
        return new SoundEntryProvider(generator);
    }

    public static void playItemPickup(Player player) {
        Level level = player.level();
        level.playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + level.random.nextFloat());
    }

    public static SoundEntry createBlock(String name, String type, String id, int var) {
        SoundEntryBuilder builder = AllSoundEvents.create(name + "_" + type).noSubtitle();
        for (int i = 0; Math.max(var, 0) > i; ++i) {
            builder = builder.addVariant(name + "/" + id + String.valueOf(var - 1 == 0 ? "" : Integer.valueOf(i + 1)));
        }
        return builder.category(SoundSource.BLOCKS).build();
    }

    public static class SoundEntryBuilder {
        protected ResourceLocation id;
        protected String subtitle = "unregistered";
        protected SoundSource category = SoundSource.BLOCKS;
        protected List<ConfiguredSoundEvent> wrappedEvents = new ArrayList<ConfiguredSoundEvent>();
        protected List<ResourceLocation> variants = new ArrayList<ResourceLocation>();
        protected int attenuationDistance;

        public SoundEntryBuilder(ResourceLocation id) {
            this.id = id;
        }

        public SoundEntryBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public SoundEntryBuilder attenuationDistance(int distance) {
            this.attenuationDistance = distance;
            return this;
        }

        public SoundEntryBuilder noSubtitle() {
            this.subtitle = null;
            return this;
        }

        public SoundEntryBuilder category(SoundSource category) {
            this.category = category;
            return this;
        }

        public SoundEntryBuilder addVariant(String name) {
            return this.addVariant(Unify.loc(name));
        }

        public SoundEntryBuilder addVariant(ResourceLocation id) {
            this.variants.add(id);
            return this;
        }

        public SoundEntryBuilder playExisting(Supplier<SoundEvent> event, float volume, float pitch) {
            this.wrappedEvents.add(new ConfiguredSoundEvent(event, volume, pitch));
            return this;
        }

        public SoundEntryBuilder playExisting(SoundEvent event, float volume, float pitch) {
            return this.playExisting(() -> event, volume, pitch);
        }

        public SoundEntryBuilder playExisting(SoundEvent event) {
            return this.playExisting(event, 1.0f, 1.0f);
        }

        public SoundEntryBuilder playExisting(Holder<SoundEvent> event) {
            return this.playExisting(() -> event.value(), 1.0f, 1.0f);
        }

        public SoundEntry build() {
            SoundEntry entry = this.wrappedEvents.isEmpty() ? new CustomSoundEntry(this.id, this.variants, this.subtitle, this.category, this.attenuationDistance) : new WrappedSoundEntry(this.id, this.subtitle, this.wrappedEvents, this.category, this.attenuationDistance);
            ALL.put(entry.getId(), entry);
            return entry;
        }
    }

    public static abstract class SoundEntry {
        protected ResourceLocation id;
        protected String subtitle;
        protected SoundSource category;
        protected int attenuationDistance;

        public SoundEntry(ResourceLocation id, String subtitle, SoundSource category, int attenuationDistance) {
            this.id = id;
            this.subtitle = subtitle;
            this.category = category;
            this.attenuationDistance = attenuationDistance;
        }

        public abstract void prepare();

        public abstract void register(RegisterEvent.RegisterHelper<SoundEvent> var1);

        public abstract void write(JsonObject var1);

        public abstract Holder<SoundEvent> getMainEventHolder();

        public abstract SoundEvent getMainEvent();

        public String getSubtitleKey() {
            return this.id.getNamespace() + ".subtitle." + this.id.getPath();
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public boolean hasSubtitle() {
            return this.subtitle != null;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public void playOnServer(Level world, Vec3i pos) {
            this.playOnServer(world, pos, 1.0f, 1.0f);
        }

        public void playOnServer(Level world, Vec3i pos, float volume, float pitch) {
            this.play(world, null, pos, volume, pitch);
        }

        public void play(Level world, Player entity, Vec3i pos) {
            this.play(world, entity, pos, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity) {
            this.playFrom(entity, 1.0f, 1.0f);
        }

        public void playFrom(Entity entity, float volume, float pitch) {
            if (!entity.isSilent()) {
                this.play(entity.level(), null, (Vec3i)entity.blockPosition(), volume, pitch);
            }
        }

        public void play(Level world, Player entity, Vec3i pos, float volume, float pitch) {
            this.play(world, entity, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, volume, pitch);
        }

        public void play(Level world, Player entity, Vec3 pos, float volume, float pitch) {
            this.play(world, entity, pos.x(), pos.y(), pos.z(), volume, pitch);
        }

        public abstract void play(Level var1, Player var2, double var3, double var5, double var7, float var9, float var10);

        public void playAt(Level world, Vec3i pos, float volume, float pitch, boolean fade) {
            this.playAt(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, volume, pitch, fade);
        }

        public void playAt(Level world, Vec3 pos, float volume, float pitch, boolean fade) {
            this.playAt(world, pos.x(), pos.y(), pos.z(), volume, pitch, fade);
        }

        public abstract void playAt(Level var1, double var2, double var4, double var6, float var8, float var9, boolean var10);
    }

    public static class SoundEntryProvider
    implements DataProvider {
        private final PackOutput output;

        public SoundEntryProvider(DataGenerator generator) {
            this.output = generator.getPackOutput();
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput cache) {
            return this.generate(this.output.getOutputFolder(), cache);
        }

        @NotNull
        public String getName() {
            return "Unify's Custom Sounds";
        }

        public CompletableFuture<?> generate(Path path, CachedOutput cache) {
            path = path.resolve("assets/unify");
            JsonObject json = new JsonObject();
            ALL.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((SoundEntry)entry.getValue()).write(json));
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
    }

    private static class CustomSoundEntry
    extends SoundEntry {
        protected List<ResourceLocation> variants;
        protected DeferredHolder<SoundEvent, SoundEvent> event;

        public CustomSoundEntry(ResourceLocation id, List<ResourceLocation> variants, String subtitle, SoundSource category, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.variants = variants;
        }

        @Override
        public void prepare() {
            this.event = DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)this.id);
        }

        @Override
        public void register(RegisterEvent.RegisterHelper<SoundEvent> helper) {
            ResourceLocation location = this.event.getId();
            helper.register(location, (Object)SoundEvent.createVariableRangeEvent((ResourceLocation)location));
        }

        @Override
        public Holder<SoundEvent> getMainEventHolder() {
            return this.event;
        }

        @Override
        public SoundEvent getMainEvent() {
            return (SoundEvent)this.event.get();
        }

        @Override
        public void write(JsonObject json) {
            JsonObject entry = new JsonObject();
            JsonArray list = new JsonArray();
            for (ResourceLocation variant : this.variants) {
                JsonObject s = new JsonObject();
                s.addProperty("name", variant.toString());
                s.addProperty("type", "file");
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
            }
            entry.add("sounds", (JsonElement)list);
            if (this.hasSubtitle()) {
                entry.addProperty("subtitle", this.getSubtitleKey());
            }
            json.add(this.id.getPath(), (JsonElement)entry);
        }

        @Override
        public void play(Level level, Player player, double x, double y, double z, float volume, float pitch) {
            level.playSound(player, x, y, z, (SoundEvent)this.event.get(), this.category, volume, pitch);
        }

        @Override
        public void playAt(Level level, double x, double y, double z, float volume, float pitch, boolean fade) {
            level.playLocalSound(x, y, z, (SoundEvent)this.event.get(), this.category, volume, pitch, fade);
        }
    }

    private static class WrappedSoundEntry
    extends SoundEntry {
        private final List<ConfiguredSoundEvent> wrappedEvents;
        private final List<CompiledSoundEvent> compiledEvents;

        public WrappedSoundEntry(ResourceLocation id, String subtitle, List<ConfiguredSoundEvent> wrappedEvents, SoundSource category, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.wrappedEvents = wrappedEvents;
            this.compiledEvents = new ArrayList<CompiledSoundEvent>();
        }

        @Override
        public void prepare() {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent wrapped = this.wrappedEvents.get(i);
                ResourceLocation location = this.getIdOf(i);
                DeferredHolder event = DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)location);
                this.compiledEvents.add(new CompiledSoundEvent((DeferredHolder<SoundEvent, SoundEvent>)event, wrapped.volume(), wrapped.pitch()));
            }
        }

        @Override
        public void register(RegisterEvent.RegisterHelper<SoundEvent> helper) {
            for (CompiledSoundEvent compiledEvent : this.compiledEvents) {
                ResourceLocation location = compiledEvent.event().getId();
                helper.register(location, (Object)SoundEvent.createVariableRangeEvent((ResourceLocation)location));
            }
        }

        @Override
        public Holder<SoundEvent> getMainEventHolder() {
            return this.compiledEvents.getFirst().event();
        }

        @Override
        public SoundEvent getMainEvent() {
            return (SoundEvent)this.compiledEvents.getFirst().event().get();
        }

        protected ResourceLocation getIdOf(int i) {
            return ResourceLocation.fromNamespaceAndPath((String)this.id.getNamespace(), (String)(i == 0 ? this.id.getPath() : this.id.getPath() + "_compounded_" + i));
        }

        @Override
        public void write(JsonObject json) {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent event = this.wrappedEvents.get(i);
                JsonObject entry = new JsonObject();
                JsonArray list = new JsonArray();
                JsonObject s = new JsonObject();
                s.addProperty("name", event.event().get().getLocation().toString());
                s.addProperty("type", "event");
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
                entry.add("sounds", (JsonElement)list);
                if (i == 0 && this.hasSubtitle()) {
                    entry.addProperty("subtitle", this.getSubtitleKey());
                }
                json.add(this.getIdOf(i).getPath(), (JsonElement)entry);
            }
        }

        @Override
        public void play(Level level, Player player, double x, double y, double z, float volume, float pitch) {
            for (CompiledSoundEvent event : this.compiledEvents) {
                level.playSound(player, x, y, z, (SoundEvent)event.event().get(), this.category, event.volume() * volume, event.pitch() * pitch);
            }
        }

        @Override
        public void playAt(Level level, double x, double y, double z, float volume, float pitch, boolean fade) {
            for (CompiledSoundEvent event : this.compiledEvents) {
                level.playLocalSound(x, y, z, (SoundEvent)event.event().get(), this.category, event.volume() * volume, event.pitch() * pitch, fade);
            }
        }

        private record CompiledSoundEvent(DeferredHolder<SoundEvent, SoundEvent> event, float volume, float pitch) {
        }
    }

    public record ConfiguredSoundEvent(Supplier<SoundEvent> event, float volume, float pitch) {
    }

    public static class BlockSoundProvider {
        public final SoundEntry BREAK;
        public final SoundEntry STEP;
        public final SoundEntry PLACE;
        public final SoundEntry HIT;
        public final SoundEntry FALL;
        private final DeferredSoundType soundType;

        public BlockSoundProvider(String name, String bID, int bVar, String sID, int sVar, String pID, int pVar, String hID, int hVar, String fID, int fVar) {
            this.BREAK = AllSoundEvents.createBlock(name, "break", bID, bVar);
            this.STEP = AllSoundEvents.createBlock(name, "step", sID, sVar);
            this.PLACE = AllSoundEvents.createBlock(name, "place", pID, pVar);
            this.HIT = AllSoundEvents.createBlock(name, "hit", hID, hVar);
            this.FALL = AllSoundEvents.createBlock(name, "fall", fID, fVar);
            this.soundType = new DeferredSoundType(0.9f, 1.0f, this.BREAK::getMainEvent, this.STEP::getMainEvent, this.PLACE::getMainEvent, this.HIT::getMainEvent, this.FALL::getMainEvent);
        }

        public DeferredSoundType get() {
            return this.soundType;
        }
    }
}

