/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.unify.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.lopyluna.unify.content.utils.UnifyRemapper;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public abstract class RecipeManagerMixin {
    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void injectAfterApply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller profiler, CallbackInfo ci) {
        List<String> outputs = List.of("result", "item_output", "secondary", "output", "results", "item_outputs", "secondaries", "outputs", "value", "values");
        List<String> inputs = List.of("ingredient", "input0", "input1", "input2", "input3", "extra_input", "main_input", "item_inputs", "item_input", "input", "additive", "addition", "base", "ingredients", "extra_inputs", "main_inputs", "inputs", "additives", "additions", "catalyst", "catalysts");
        List<String> inner = List.of("basePredicate", "output", "value");
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            if (!json.isJsonObject()) continue;
            JsonObject obj = json.getAsJsonObject();
            UnifyRemapper.handleRemapping(entry, json, obj, inputs, inner);
            UnifyRemapper.handleRemapping(entry, json, obj, outputs, inner);
        }
    }
}

