/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.unify.mixin;

import dev.lopyluna.unify.content.utils.UnifyRemapper;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    @Final
    @Nullable
    private Item item;

    @Shadow
    public abstract Item getItem();

    @Shadow
    public abstract boolean isEmpty();

    @Inject(method={"getItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void unify$remapGetItem(CallbackInfoReturnable<Item> cir) {
        if (this.isEmpty()) {
            cir.setReturnValue((Object)Items.AIR);
        } else {
            Item remapped = UnifyRemapper.remapItem(this.item);
            cir.setReturnValue((Object)remapped);
        }
    }
}

