/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.unify.helper;

import com.tterrag.registrate.builders.BlockBuilder;
import dev.lopyluna.unify.Unify;
import dev.lopyluna.unify.content.AllUtils;
import dev.lopyluna.unify.helper.MetalEntry;
import dev.lopyluna.unify.helper.MetalType;
import dev.lopyluna.unify.register.AllTags;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public class MetalOreEntry
extends MetalEntry {
    public Supplier<Item> rawMaterial;
    public Supplier<Item> crushedOre;
    public Supplier<Block> rawStorage;
    public Supplier<Block> oreStone;
    public Supplier<Block> oreDeepslate;
    public final String rawID;
    public final String rawType;
    public final MapColor rawColor;
    public final SoundType rawSound;

    public MetalOreEntry(String type, MapColor color, SoundType sound) {
        this(type, color, sound, type, color, SoundType.STONE);
    }

    public MetalOreEntry(String type, MapColor color, SoundType sound, MapColor rawColor) {
        this(type, color, sound, type, rawColor, SoundType.STONE);
    }

    public MetalOreEntry(String type, MapColor color, SoundType sound, SoundType rawSound) {
        this(type, color, sound, type, color, rawSound);
    }

    public MetalOreEntry(String type, MapColor color, SoundType sound, MapColor rawColor, SoundType rawSound) {
        this(type, color, sound, type, rawColor, rawSound);
    }

    public MetalOreEntry(String type, MapColor color, SoundType sound, String rawType) {
        this(type, color, sound, rawType, color, SoundType.STONE);
    }

    public MetalOreEntry(String type, MapColor color, SoundType sound, String rawType, MapColor rawColor) {
        this(type, color, sound, rawType, rawColor, SoundType.STONE);
    }

    public MetalOreEntry(String type, MapColor color, SoundType sound, String rawType, SoundType rawSound) {
        this(type, color, sound, rawType, color, rawSound);
    }

    public MetalOreEntry(String type, MapColor color, SoundType sound, String rawType, MapColor rawColor, SoundType rawSound) {
        super(type, color, sound);
        this.rawID = rawType.toLowerCase().replace(" ", "_");
        this.rawType = rawType;
        this.rawColor = rawColor;
        this.rawSound = rawSound;
    }

    @Override
    public MetalOreEntry mineable(TagKey<Block> mineable) {
        super.mineable(mineable);
        return this;
    }

    @Override
    public MetalOreEntry beaconCompatible() {
        super.beaconCompatible();
        return this;
    }

    @Override
    public MetalOreEntry smallBlock() {
        super.smallBlock();
        return this;
    }

    @Override
    public MetalOreEntry woodenMineable() {
        super.woodenMineable();
        return this;
    }

    @Override
    public MetalOreEntry stoneMineable() {
        super.stoneMineable();
        return this;
    }

    @Override
    public MetalOreEntry ironMineable() {
        super.ironMineable();
        return this;
    }

    @Override
    public MetalOreEntry goldMineable() {
        super.goldMineable();
        return this;
    }

    @Override
    public MetalOreEntry diamondMineable() {
        super.diamondMineable();
        return this;
    }

    @Override
    public MetalOreEntry netheriteMineable() {
        super.netheriteMineable();
        return this;
    }

    @Override
    public MetalOreEntry ingot(ItemLike item) {
        super.ingot(item);
        return this;
    }

    @Override
    public MetalOreEntry nugget(ItemLike item) {
        super.nugget(item);
        return this;
    }

    @Override
    public MetalOreEntry sheet(ItemLike item) {
        super.sheet(item);
        return this;
    }

    @Override
    public MetalOreEntry gear(ItemLike item) {
        super.gear(item);
        return this;
    }

    @Override
    public MetalOreEntry rod(ItemLike item) {
        super.rod(item);
        return this;
    }

    @Override
    public MetalOreEntry wire(ItemLike item) {
        super.wire(item);
        return this;
    }

    @Override
    public MetalOreEntry dust(ItemLike item) {
        super.dust(item);
        return this;
    }

    @Override
    public MetalOreEntry storage(ItemLike item) {
        super.storage(item);
        return this;
    }

    @Override
    public MetalOreEntry storage(Block block) {
        super.storage(block);
        return this;
    }

    public MetalOreEntry rawMaterial(ItemLike item) {
        this.rawMaterial = () -> ((ItemLike)item).asItem();
        return this;
    }

    public MetalOreEntry crushedOre(ItemLike item) {
        this.crushedOre = () -> ((ItemLike)item).asItem();
        return this;
    }

    public MetalOreEntry rawStorage(ItemLike item) {
        Item item2 = item.asItem();
        if (item2 instanceof BlockItem) {
            BlockItem block = (BlockItem)item2;
            this.rawStorage = () -> ((BlockItem)block).getBlock();
        }
        return this;
    }

    public MetalOreEntry rawStorage(Block block) {
        this.rawStorage = () -> block;
        return this;
    }

    public MetalOreEntry oreStone(ItemLike item) {
        Item item2 = item.asItem();
        if (item2 instanceof BlockItem) {
            BlockItem block = (BlockItem)item2;
            this.oreStone = () -> ((BlockItem)block).getBlock();
        }
        return this;
    }

    public MetalOreEntry oreStone(Block block) {
        this.oreStone = () -> block;
        return this;
    }

    public MetalOreEntry oreDeepslate(ItemLike item) {
        Item item2 = item.asItem();
        if (item2 instanceof BlockItem) {
            BlockItem block = (BlockItem)item2;
            this.oreDeepslate = () -> ((BlockItem)block).getBlock();
        }
        return this;
    }

    public MetalOreEntry oreDeepslate(Block block) {
        this.oreDeepslate = () -> block;
        return this;
    }

    @Override
    public Supplier<ItemLike> get(MetalType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MetalType.INGOT -> ((Supplier)this.ingot)::get;
            case MetalType.NUGGET -> ((Supplier)this.nugget)::get;
            case MetalType.SHEET -> ((Supplier)this.sheet)::get;
            case MetalType.GEAR -> ((Supplier)this.gear)::get;
            case MetalType.WIRE -> ((Supplier)this.wire)::get;
            case MetalType.ROD -> ((Supplier)this.rod)::get;
            case MetalType.DUST -> ((Supplier)this.dust)::get;
            case MetalType.STORAGE -> ((Supplier)this.storage)::get;
            case MetalType.RAW -> this.rawMaterial::get;
            case MetalType.RAW_CRUSHED -> this.crushedOre::get;
            case MetalType.RAW_STORAGE -> this.rawStorage::get;
            case MetalType.ORE_STONE -> this.oreStone::get;
            case MetalType.ORE_DEEPSLATE -> this.oreDeepslate::get;
            case MetalType.NA -> null;
        };
    }

    @Override
    public Supplier<Block> getBlock(MetalType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MetalType.STORAGE -> this.storage;
            case MetalType.RAW_STORAGE -> this.rawStorage;
            case MetalType.ORE_STONE -> this.oreStone;
            case MetalType.ORE_DEEPSLATE -> this.oreDeepslate;
            case MetalType.INGOT, MetalType.NUGGET, MetalType.SHEET, MetalType.GEAR, MetalType.WIRE, MetalType.ROD, MetalType.DUST, MetalType.RAW, MetalType.RAW_CRUSHED, MetalType.NA -> null;
        };
    }

    @Override
    public MetalOreEntry register() {
        super.register();
        TagKey<Item> rawMaterialTag = AllTags.itemC("raw_materials/" + this.rawID);
        if (this.rawMaterial == null) {
            this.rawMaterial = Unify.REG.item("raw_" + this.rawID, Item::new).lang("Raw " + this.rawType).tag(new TagKey[]{rawMaterialTag, AllTags.itemC("raw_materials")}).register();
        }
        this.itemEntries.add(this.rawMaterial);
        this.tagKeys.add(rawMaterialTag);
        TagKey<Item> rawDust = AllTags.itemC("dusts/raw_" + this.rawID);
        if (this.crushedOre == null) {
            this.crushedOre = Unify.REG.item("crushed_raw_" + this.rawID, Item::new).lang("Crushed Raw " + this.rawType).tag(new TagKey[]{rawDust, AllTags.itemC("dusts")}).register();
        }
        this.itemEntries.add(this.crushedOre);
        this.tagKeys.add(rawDust);
        TagKey<Item> storageTag = AllTags.itemC("storage_blocks/raw_" + this.rawID);
        if (this.rawStorage == null) {
            this.rawStorage = ((BlockBuilder)((BlockBuilder)Unify.REG.block("raw_" + this.rawID + "_block", Block::new).lang(this.blockOf ? "Block of Raw " + this.rawType : "Raw " + this.rawType + " Block").initialProperties(() -> Blocks.RAW_IRON_BLOCK).properties(p -> p.requiresCorrectToolForDrops().mapColor(this.rawColor).sound(this.rawSound)).transform(AllUtils.pickaxeOnly())).tag(new TagKey[]{this.mineable != null ? this.mineable : BlockTags.NEEDS_STONE_TOOL}).tag(new TagKey[]{AllTags.blockC("storage_blocks/raw_" + this.rawID), AllTags.blockC("storage_blocks")}).item().tag(new TagKey[]{storageTag, AllTags.itemC("storage_blocks")}).build()).register();
        }
        this.blockEntries.add(this.rawStorage);
        this.tagKeys.add(storageTag);
        TagKey<Item> oresTag = AllTags.itemC("ores/" + this.rawID);
        if (this.oreStone == null) {
            this.oreStone = ((BlockBuilder)((BlockBuilder)Unify.REG.block(this.rawID + "_ore", Block::new).lang(this.rawType + " Ore").initialProperties(() -> Blocks.IRON_ORE).properties(p -> p.requiresCorrectToolForDrops().mapColor(this.rawColor)).transform(AllUtils.pickaxeOnly())).loot((lt, b) -> lt.add(b, lt.createSilkTouchDispatchTable(b, (LootPoolEntryContainer.Builder)lt.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)this.rawMaterial.get())).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)lt.getRegistries().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE))))))).tag(new TagKey[]{this.mineable != null ? this.mineable : BlockTags.NEEDS_STONE_TOOL}).tag(new TagKey[]{AllTags.blockC("ores/" + this.rawID), AllTags.blockC("ores"), AllTags.blockC("ores_in_ground/stone")}).item().tag(new TagKey[]{oresTag, AllTags.itemC("ores"), AllTags.itemC("ores_in_ground/stone")}).build()).register();
        }
        this.blockEntries.add(this.oreStone);
        if (this.oreDeepslate == null) {
            this.oreDeepslate = ((BlockBuilder)((BlockBuilder)Unify.REG.block("deepslate_" + this.rawID + "_ore", Block::new).lang("Deepslate " + this.rawType + " Ore").initialProperties(() -> Blocks.DEEPSLATE_IRON_ORE).properties(p -> p.requiresCorrectToolForDrops().mapColor(this.rawColor)).transform(AllUtils.pickaxeOnly())).loot((lt, b) -> lt.add(b, lt.createSilkTouchDispatchTable(b, (LootPoolEntryContainer.Builder)lt.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)this.rawMaterial.get())).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)lt.getRegistries().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE))))))).tag(new TagKey[]{this.mineable != null ? this.mineable : BlockTags.NEEDS_STONE_TOOL}).tag(new TagKey[]{AllTags.blockC("ores/" + this.rawID), AllTags.blockC("ores"), AllTags.blockC("ores_in_ground/deepslate")}).item().tag(new TagKey[]{oresTag, AllTags.itemC("ores"), AllTags.itemC("ores_in_ground/deepslate")}).build()).register();
        }
        this.blockEntries.add(this.oreDeepslate);
        this.tagKeys.add(oresTag);
        return this;
    }
}

