/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.unify.helper;

import com.tterrag.registrate.builders.BlockBuilder;
import dev.lopyluna.unify.Unify;
import dev.lopyluna.unify.content.AllUtils;
import dev.lopyluna.unify.helper.MaterialEntry;
import dev.lopyluna.unify.helper.MetalType;
import dev.lopyluna.unify.register.AllTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.common.Tags;

public class MetalEntry
extends MaterialEntry {
    public Supplier<Item> ingot = null;
    public Supplier<Item> nugget = null;
    public Supplier<Item> sheet = null;
    public Supplier<Item> gear = null;
    public Supplier<Item> wire = null;
    public Supplier<Item> rod = null;
    public Supplier<Item> dust = null;
    public Supplier<Block> storage = null;
    private TagKey<Item> itemTag = null;
    protected List<Supplier<Item>> itemEntries = new ArrayList<Supplier<Item>>();
    protected List<Supplier<Block>> blockEntries = new ArrayList<Supplier<Block>>();
    protected List<TagKey<Item>> tagKeys = new ArrayList<TagKey<Item>>();
    protected TagKey<Block> mineable = null;
    protected boolean beaconCompatible = false;
    protected boolean blockOf = true;

    public MetalEntry(String type, MapColor color, SoundType sound) {
        super(type, color, sound);
    }

    public MetalEntry mineable(TagKey<Block> mineable) {
        this.mineable = mineable;
        return this;
    }

    public MetalEntry woodenMineable() {
        return this.mineable((TagKey<Block>)Tags.Blocks.NEEDS_WOOD_TOOL);
    }

    public MetalEntry stoneMineable() {
        return this.mineable((TagKey<Block>)BlockTags.NEEDS_STONE_TOOL);
    }

    public MetalEntry goldMineable() {
        return this.mineable((TagKey<Block>)Tags.Blocks.NEEDS_GOLD_TOOL);
    }

    public MetalEntry ironMineable() {
        return this.mineable((TagKey<Block>)BlockTags.NEEDS_IRON_TOOL);
    }

    public MetalEntry diamondMineable() {
        return this.mineable((TagKey<Block>)BlockTags.NEEDS_DIAMOND_TOOL);
    }

    public MetalEntry netheriteMineable() {
        return this.mineable((TagKey<Block>)Tags.Blocks.NEEDS_NETHERITE_TOOL);
    }

    public MetalEntry beaconCompatible() {
        this.beaconCompatible = true;
        return this;
    }

    public MetalEntry smallBlock() {
        this.blockOf = false;
        return this;
    }

    private MetalEntry itemTag(TagKey<Item> itemTag) {
        this.itemTag = itemTag;
        return this;
    }

    public MetalEntry ingot(ItemLike item) {
        this.ingot = () -> ((ItemLike)item).asItem();
        return this;
    }

    public MetalEntry nugget(ItemLike item) {
        this.nugget = () -> ((ItemLike)item).asItem();
        return this;
    }

    public MetalEntry sheet(ItemLike item) {
        this.sheet = () -> ((ItemLike)item).asItem();
        return this;
    }

    public MetalEntry gear(ItemLike item) {
        this.gear = () -> ((ItemLike)item).asItem();
        return this;
    }

    public MetalEntry rod(ItemLike item) {
        this.rod = () -> ((ItemLike)item).asItem();
        return this;
    }

    public MetalEntry wire(ItemLike item) {
        this.wire = () -> ((ItemLike)item).asItem();
        return this;
    }

    public MetalEntry dust(ItemLike item) {
        this.dust = () -> ((ItemLike)item).asItem();
        return this;
    }

    public MetalEntry storage(ItemLike item) {
        Item item2 = item.asItem();
        if (item2 instanceof BlockItem) {
            BlockItem block = (BlockItem)item2;
            this.storage = () -> ((BlockItem)block).getBlock();
        }
        return this;
    }

    public MetalEntry storage(Block block) {
        this.storage = () -> block;
        return this;
    }

    public Supplier<ItemLike> get(MetalType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MetalType.INGOT -> this.ingot::get;
            case MetalType.NUGGET -> this.nugget::get;
            case MetalType.SHEET -> this.sheet::get;
            case MetalType.GEAR -> this.gear::get;
            case MetalType.WIRE -> this.wire::get;
            case MetalType.ROD -> this.rod::get;
            case MetalType.DUST -> this.dust::get;
            case MetalType.STORAGE -> this.storage::get;
            case MetalType.RAW, MetalType.RAW_CRUSHED, MetalType.RAW_STORAGE, MetalType.ORE_STONE, MetalType.ORE_DEEPSLATE, MetalType.NA -> null;
        };
    }

    public Supplier<Block> getBlock(MetalType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MetalType.STORAGE -> this.storage;
            case MetalType.INGOT, MetalType.NUGGET, MetalType.SHEET, MetalType.GEAR, MetalType.WIRE, MetalType.ROD, MetalType.DUST, MetalType.RAW, MetalType.RAW_CRUSHED, MetalType.RAW_STORAGE, MetalType.ORE_STONE, MetalType.ORE_DEEPSLATE, MetalType.NA -> null;
        };
    }

    @Override
    public MetalEntry register() {
        TagKey<Item> ingotTag = AllTags.itemC("ingots/" + this.id);
        if (this.ingot == null) {
            this.ingot = Unify.REG.item(this.id + "_ingot", Item::new).lang(this.type + " Ingot").tag(new TagKey[]{this.beaconCompatible ? ItemTags.BEACON_PAYMENT_ITEMS : AllTags.item("raw_beacon")}).tag(new TagKey[]{ingotTag, AllTags.itemC("ingots")}).register();
        }
        this.itemEntries.add(this.ingot);
        this.tagKeys.add(ingotTag);
        TagKey<Item> nuggetTag = AllTags.itemC("nuggets/" + this.id);
        if (this.nugget == null) {
            this.nugget = Unify.REG.item(this.id + "_nugget", Item::new).lang(this.type + " Nugget").tag(new TagKey[]{nuggetTag, AllTags.itemC("nuggets")}).register();
        }
        this.itemEntries.add(this.nugget);
        this.tagKeys.add(nuggetTag);
        TagKey<Item> sheetTag = AllTags.itemC("plates/" + this.id);
        if (this.sheet == null) {
            this.sheet = Unify.REG.item(this.id + "_sheet", Item::new).lang(this.type + " Sheet").tag(new TagKey[]{sheetTag, AllTags.itemC("plates")}).register();
        }
        this.itemEntries.add(this.sheet);
        this.tagKeys.add(sheetTag);
        TagKey<Item> gearTag = AllTags.itemC("gears/" + this.id);
        if (this.gear == null) {
            this.gear = Unify.REG.item(this.id + "_gear", Item::new).lang(this.type + " Gear").tag(new TagKey[]{gearTag, AllTags.itemC("gears")}).register();
        }
        this.itemEntries.add(this.gear);
        this.tagKeys.add(gearTag);
        TagKey<Item> rodTag = AllTags.itemC("rods/" + this.id);
        if (this.rod == null) {
            this.rod = Unify.REG.item(this.id + "_rod", Item::new).lang(this.type + " Rod").model((c, p) -> ((ItemModelBuilder)p.withExistingParent(c.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/handheld"))).texture("layer0", Unify.loc("item/" + c.getId().getPath()))).tag(new TagKey[]{rodTag, AllTags.itemC("rods")}).register();
        }
        this.itemEntries.add(this.rod);
        this.tagKeys.add(rodTag);
        TagKey<Item> wireTag = AllTags.itemC("wires/" + this.id);
        if (this.wire == null) {
            this.wire = Unify.REG.item(this.id + "_wire", Item::new).lang(this.type + " Wire").tag(new TagKey[]{wireTag, AllTags.itemC("wires")}).register();
        }
        this.itemEntries.add(this.wire);
        this.tagKeys.add(wireTag);
        TagKey<Item> dustTag = AllTags.itemC("dusts/" + this.id);
        if (this.dust == null) {
            this.dust = Unify.REG.item(this.id + "_dust", Item::new).lang(this.type + " Dust").tag(new TagKey[]{dustTag, AllTags.itemC("dusts")}).register();
        }
        this.itemEntries.add(this.dust);
        this.tagKeys.add(dustTag);
        TagKey<Item> storageTag = AllTags.itemC("storage_blocks/" + this.id);
        if (this.storage == null) {
            this.storage = ((BlockBuilder)((BlockBuilder)Unify.REG.block(this.id + "_block", Block::new).lang(this.blockOf ? "Block of " + this.type : this.type + " Block").initialProperties(() -> Blocks.IRON_BLOCK).properties(p -> p.requiresCorrectToolForDrops().mapColor(this.color).sound(this.sound)).transform(AllUtils.pickaxeOnly())).tag(new TagKey[]{this.beaconCompatible ? BlockTags.BEACON_BASE_BLOCKS : AllTags.block("raw_beacon")}).tag(new TagKey[]{this.mineable != null ? this.mineable : BlockTags.NEEDS_STONE_TOOL}).tag(new TagKey[]{AllTags.blockC("storage_blocks/" + this.id), AllTags.blockC("storage_blocks")}).item().tag(new TagKey[]{storageTag, AllTags.itemC("storage_blocks")}).build()).register();
        }
        this.blockEntries.add(this.storage);
        this.tagKeys.add(storageTag);
        return this;
    }
}

