/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.unify.events;

import dev.lopyluna.unify.content.utils.UnifyRemapper;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="unify", bus=EventBusSubscriber.Bus.GAME)
public class ServerEvents {
    @SubscribeEvent
    public static void onServerLoad(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        RegistryAccess.Frozen prov = server.registryAccess();
        UnifyRemapper.register((HolderLookup.Provider)prov);
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        RegistryAccess.Frozen prov = server.registryAccess();
        UnifyRemapper.register((HolderLookup.Provider)prov);
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        RegistryAccess.Frozen prov = server.registryAccess();
        UnifyRemapper.register((HolderLookup.Provider)prov);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Post event) {
        Vec3 vec31;
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (level.isClientSide) return;
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (entity.tickCount % 4 == 0) {
                ItemStack newStack;
                ItemStack itemStack = itemEntity.getItem();
                if (itemStack.equals(newStack = UnifyRemapper.remapItemStack(itemStack))) return;
                itemEntity.setItem(newStack);
                return;
            }
        }
        if (!(entity instanceof Player)) return;
        Player player = (Player)entity;
        if (entity.tickCount % 4 == 0) {
            ItemStack newCarried;
            Object object = player.hasContainerOpen() ? player.containerMenu : player.inventoryMenu;
            ItemStack carried = object.getCarried();
            if (!carried.equals(newCarried = UnifyRemapper.remapItemStack(carried))) {
                object.setCarried(newCarried);
            }
            for (Slot slot : object.slots) {
                ItemStack newStack;
                ItemStack itemStack = slot.getItem();
                if (itemStack.equals(newStack = UnifyRemapper.remapItemStack(itemStack))) continue;
                slot.set(newStack);
            }
        }
        if (entity.tickCount % 2 != 0) return;
        Vec3 vec3 = player.getEyePosition();
        BlockHitResult hit = level.clip(new ClipContext(vec3, vec31 = vec3.add(player.calculateViewVector(player.getXRot(), player.getYRot()).scale(64.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hit.getType() == HitResult.Type.MISS) return;
        BlockPos hitPos = hit.getBlockPos();
        Iterator iterator = BlockPos.betweenClosed((BlockPos)hitPos.offset(1, 1, 1), (BlockPos)hitPos.offset(-1, -1, -1)).iterator();
        while (iterator.hasNext()) {
            BlockState newState;
            BlockPos pos = (BlockPos)iterator.next();
            BlockState state = level.getBlockState(pos);
            if (state.equals(newState = UnifyRemapper.remapBlockState(state))) continue;
            level.setBlock(pos, newState, 2);
        }
    }
}

