/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.unify.content.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.lopyluna.unify.content.AllUtils;
import dev.lopyluna.unify.helper.MaterialEntry;
import dev.lopyluna.unify.helper.MetalEntry;
import dev.lopyluna.unify.helper.MetalType;
import dev.lopyluna.unify.register.AllTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class UnifyRemapper {
    public static final List<Item> ITEM_DISPLAY = new ArrayList<Item>();
    public static final List<Item> ITEM_HIDDEN = new ArrayList<Item>();
    private static final Map<ResourceLocation, ResourceLocation> ITEMID_REMAP = new HashMap<ResourceLocation, ResourceLocation>();
    private static final Map<Item, Item> ITEM_REMAP = new HashMap<Item, Item>();
    private static final Map<ResourceLocation, ResourceLocation> BLOCKID_REMAP = new HashMap<ResourceLocation, ResourceLocation>();
    private static final Map<Block, Block> BLOCK_REMAP = new HashMap<Block, Block>();
    private static final Map<String, String> ID_REMAP = new HashMap<String, String>();

    public static void register() {
        UnifyRemapper.buildBlockRemap();
        UnifyRemapper.buildItemRemap();
    }

    public static void register(HolderLookup.Provider provider) {
        UnifyRemapper.register();
        UnifyRemapper.buildIDRemap(provider);
    }

    public static void buildBlockRemap() {
        for (Map.Entry entry : BuiltInRegistries.BLOCK.entrySet()) {
            Block remap;
            ResourceLocation remapID;
            Block block = (Block)entry.getValue();
            ResourceLocation blockID = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (blockID.getNamespace().equals("unify") || blockID.equals((Object)(remapID = BuiltInRegistries.BLOCK.getKey((Object)(remap = UnifyRemapper.remapBlocks(block)))))) continue;
            if (!BLOCKID_REMAP.containsKey(blockID)) {
                BLOCKID_REMAP.put(blockID, remapID);
            }
            if (!BLOCK_REMAP.containsKey(block)) {
                BLOCK_REMAP.put(block, remap);
            }
            Item itemAlt = block.asItem();
            Item remapAlt = remap.asItem();
            if (!ITEM_DISPLAY.contains(remapAlt)) {
                ITEM_DISPLAY.add(remapAlt);
            }
            if (ITEM_HIDDEN.contains(itemAlt)) continue;
            ITEM_HIDDEN.add(itemAlt);
        }
    }

    public static void buildItemRemap() {
        for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
            Item remap;
            ResourceLocation remapID;
            Item item = (Item)entry.getValue();
            ResourceLocation itemID = BuiltInRegistries.ITEM.getKey((Object)item);
            if (itemID.getNamespace().equals("unify") || itemID.equals((Object)(remapID = BuiltInRegistries.ITEM.getKey((Object)(remap = UnifyRemapper.remapItems(item)))))) continue;
            if (!ID_REMAP.containsKey(itemID.toString())) {
                ID_REMAP.put(itemID.toString(), remapID.toString());
            }
            if (!ITEMID_REMAP.containsKey(itemID)) {
                ITEMID_REMAP.put(itemID, remapID);
            }
            if (!ITEM_REMAP.containsKey(item)) {
                ITEM_REMAP.put(item, remap);
            }
            if (!ITEM_DISPLAY.contains(remap)) {
                ITEM_DISPLAY.add(remap);
            }
            if (ITEM_HIDDEN.contains(item)) continue;
            ITEM_HIDDEN.add(item);
        }
    }

    public static void buildIDRemap(HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup itemLookup = provider.lookupOrThrow(Registries.ITEM);
        for (TagKey tag : itemLookup.listTagIds().toList()) {
            String remap;
            String loc = tag.location().toString();
            if (loc.equals(remap = UnifyRemapper.remapLocIDs(loc)) || ID_REMAP.containsKey(loc)) continue;
            ID_REMAP.put(loc, remap);
        }
    }

    public static Item remapItem(Item item) {
        Item newItem = ITEM_REMAP.get(item);
        return newItem != null ? newItem : item;
    }

    public static ItemStack remapItemStack(ItemStack stack) {
        Item item = ITEM_REMAP.get(stack.getItem());
        return item != null ? stack.transmuteCopy((ItemLike)item) : stack;
    }

    public static Block remapBlock(Block block) {
        Block newBlock = BLOCK_REMAP.get(block);
        return newBlock != null ? newBlock : block;
    }

    public static BlockState remapBlockState(BlockState state) {
        Block block = BLOCK_REMAP.get(state.getBlock());
        return block != null ? block.defaultBlockState() : state;
    }

    public static ResourceLocation remapItemID(ResourceLocation loc) {
        ResourceLocation item = ITEMID_REMAP.get(loc);
        return item != null ? item : loc;
    }

    public static ResourceLocation remapBlockID(ResourceLocation loc) {
        ResourceLocation block = BLOCKID_REMAP.get(loc);
        return block != null ? block : loc;
    }

    public static String remapID(String id) {
        String target = ID_REMAP.get(id);
        return target != null ? target : id;
    }

    private static Block remapBlocks(Block block) {
        Object v;
        MetalType check;
        MetalType type = MetalType.NA;
        Holder.Reference registry = block.builtInRegistryHolder();
        List<TagKey<Block>> tags = registry.tags().toList();
        String id = AllUtils.safeId((ItemLike)block);
        ArrayList<String> newList = new ArrayList<String>(MaterialEntry.types);
        newList.sort((a, b) -> Integer.compare(b.length(), a.length()));
        String metal = "";
        for (String s : newList) {
            if (!id.contains(s)) continue;
            metal = s;
            break;
        }
        if ((check = UnifyRemapper.checkTypeForBlock(metal, id, tags)) != MetalType.NA) {
            type = check;
        }
        if (type == MetalType.NA && metal.equals("gold") && (check = UnifyRemapper.checkTypeForBlock("golden", id, tags)) != MetalType.NA) {
            type = check;
        }
        if (type == MetalType.NA) {
            return block;
        }
        Block remapped = null;
        if (!metal.isEmpty() && (v = MetalEntry.typeEntries.get(metal)) instanceof MetalEntry) {
            MetalEntry entry = (MetalEntry)v;
            remapped = entry.getBlock(type).get();
        }
        return remapped != null ? remapped : block;
    }

    private static MetalType checkTypeForBlock(String metal, String id, List<TagKey<Block>> tags) {
        if (tags.contains(AllTags.blockC("storage_blocks/" + metal))) {
            return MetalType.STORAGE;
        }
        if (tags.contains(AllTags.blockC("storage_blocks/raw_" + metal))) {
            return MetalType.RAW_STORAGE;
        }
        if (tags.contains(AllTags.blockC("ores/" + metal))) {
            if (tags.contains(AllTags.blockC("ores_in_ground/stone"))) {
                return MetalType.ORE_STONE;
            }
            if (tags.contains(AllTags.blockC("ores_in_ground/deepslate"))) {
                return MetalType.ORE_DEEPSLATE;
            }
        } else {
            if (id.equals(metal + "_storage_block") || id.equals("storage_block_" + metal) || id.equals(metal + "_storage") || id.equals("storage_" + metal) || id.equals(metal + "_block") || id.equals("block_" + metal)) {
                return MetalType.STORAGE;
            }
            if (id.equals("stone_" + metal + "_ore") || id.equals("ore_" + metal + "_stone") || id.equals(metal + "_stone_ore") || id.equals(metal + "_ore_stone") || id.equals("stone_ore_" + metal) || id.equals("ore_stone_" + metal) || id.equals(metal + "_ore") || id.equals("ore_" + metal)) {
                return MetalType.ORE_STONE;
            }
            if (id.equals("deepslate_" + metal + "_ore") || id.equals("ore_" + metal + "_deepslate") || id.equals(metal + "_deepslate_ore") || id.equals(metal + "_ore_deepslate") || id.equals("deepslate_ore_" + metal) || id.equals("ore_deepslate_" + metal)) {
                return MetalType.ORE_DEEPSLATE;
            }
            if (id.equals("raw_" + metal + "_storage_block") || id.equals("storage_block_" + metal + "_raw") || id.equals("raw_" + metal + "_storage") || id.equals("storage_" + metal + "_raw") || id.equals("raw_" + metal + "_block") || id.equals("block_" + metal + "_raw") || id.equals(metal + "_raw_storage_block") || id.equals("storage_block_raw_" + metal) || id.equals(metal + "_raw_storage") || id.equals("storage_raw_" + metal) || id.equals(metal + "_raw_block") || id.equals("block_raw_" + metal) || id.equals(metal + "_storage_block_raw") || id.equals("raw_storage_block_" + metal) || id.equals(metal + "_storage_raw") || id.equals("raw_storage_" + metal) || id.equals(metal + "_block_raw") || id.equals("raw_block_" + metal)) {
                return MetalType.RAW_STORAGE;
            }
        }
        return MetalType.NA;
    }

    private static Item remapItems(Item item) {
        Object v;
        MetalType check;
        MetalType type = MetalType.NA;
        Holder.Reference registry = item.builtInRegistryHolder();
        List<TagKey<Item>> tags = registry.tags().toList();
        String id = AllUtils.safeId((ItemLike)item);
        ArrayList<String> newList = new ArrayList<String>(MaterialEntry.types);
        newList.sort((a, b) -> Integer.compare(b.length(), a.length()));
        String metal = "";
        for (String s : newList) {
            if (!id.contains(s)) continue;
            metal = s;
            break;
        }
        if ((check = UnifyRemapper.checkTypeForItem(metal, id, tags)) != MetalType.NA) {
            type = check;
        }
        if (type == MetalType.NA && metal.equals("gold") && (check = UnifyRemapper.checkTypeForItem("golden", id, tags)) != MetalType.NA) {
            type = check;
        }
        if (type == MetalType.NA) {
            return item;
        }
        Item remapped = null;
        if (!metal.isEmpty() && (v = MetalEntry.typeEntries.get(metal)) instanceof MetalEntry) {
            MetalEntry entry = (MetalEntry)v;
            remapped = entry.get(type).get().asItem();
        }
        return remapped != null ? remapped : item;
    }

    private static MetalType checkTypeForItem(String metal, String id, List<TagKey<Item>> tags) {
        if (tags.contains(AllTags.itemC("storage_blocks/" + metal))) {
            return MetalType.STORAGE;
        }
        if (tags.contains(AllTags.itemC("ingots/" + metal))) {
            return MetalType.INGOT;
        }
        if (tags.contains(AllTags.itemC("nuggets/" + metal))) {
            return MetalType.NUGGET;
        }
        if (tags.contains(AllTags.itemC("plates/" + metal))) {
            return MetalType.SHEET;
        }
        if (tags.contains(AllTags.itemC("gears/" + metal))) {
            return MetalType.GEAR;
        }
        if (tags.contains(AllTags.itemC("wires/" + metal))) {
            return MetalType.WIRE;
        }
        if (tags.contains(AllTags.itemC("rods/" + metal))) {
            return MetalType.ROD;
        }
        if (tags.contains(AllTags.itemC("dusts/" + metal))) {
            return MetalType.DUST;
        }
        if (tags.contains(AllTags.itemC("raw_materials/" + metal))) {
            return MetalType.RAW;
        }
        if (tags.contains(AllTags.itemC("dusts/raw_" + metal))) {
            return MetalType.RAW_CRUSHED;
        }
        if (tags.contains(AllTags.itemC("storage_blocks/raw_" + metal))) {
            return MetalType.RAW_STORAGE;
        }
        if (tags.contains(AllTags.itemC("ores/" + metal))) {
            if (tags.contains(AllTags.itemC("ores_in_ground/stone"))) {
                return MetalType.ORE_STONE;
            }
            if (tags.contains(AllTags.itemC("ores_in_ground/deepslate"))) {
                return MetalType.ORE_DEEPSLATE;
            }
        } else {
            if (id.equals(metal + "_storage_block") || id.equals("storage_block_" + metal) || id.equals(metal + "_storage") || id.equals("storage_" + metal) || id.equals(metal + "_block") || id.equals("block_" + metal)) {
                return MetalType.STORAGE;
            }
            if (id.equals(metal + "_ingot") || id.equals("ingot_" + metal)) {
                return MetalType.INGOT;
            }
            if (id.equals(metal + "_nugget") || id.equals("nugget_" + metal)) {
                return MetalType.NUGGET;
            }
            if (id.equals(metal + "_plate") || id.equals("plate_" + metal) || id.equals(metal + "_sheet") || id.equals("sheet_" + metal)) {
                return MetalType.SHEET;
            }
            if (id.equals(metal + "_gear") || id.equals("gear_" + metal)) {
                return MetalType.GEAR;
            }
            if (id.equals(metal + "_wire") || id.equals("wire_" + metal)) {
                return MetalType.WIRE;
            }
            if (id.equals(metal + "_rod") || id.equals("rod_" + metal)) {
                return MetalType.ROD;
            }
            if (id.equals(metal + "_dust") || id.equals("dust_" + metal) || id.equals(metal + "_crushed") || id.equals("crushed_" + metal)) {
                return MetalType.DUST;
            }
            if (id.equals(metal + "_raw") || id.equals("raw_" + metal)) {
                return MetalType.RAW;
            }
            if (id.equals("crushed_" + metal + "_raw") || id.equals("raw_" + metal + "_crushed") || id.equals(metal + "_crushed_raw") || id.equals(metal + "_raw_crushed") || id.equals("crushed_raw_" + metal) || id.equals("raw_crushed_" + metal) || id.equals("dust_" + metal + "_raw") || id.equals("raw_" + metal + "_dust") || id.equals(metal + "_dust_raw") || id.equals(metal + "_raw_dust") || id.equals("dust_raw_" + metal) || id.equals("raw_dust_" + metal)) {
                return MetalType.RAW_CRUSHED;
            }
            if (id.equals("stone_" + metal + "_ore") || id.equals("ore_" + metal + "_stone") || id.equals(metal + "_stone_ore") || id.equals(metal + "_ore_stone") || id.equals("stone_ore_" + metal) || id.equals("ore_stone_" + metal) || id.equals(metal + "_ore") || id.equals("ore_" + metal)) {
                return MetalType.ORE_STONE;
            }
            if (id.equals("deepslate_" + metal + "_ore") || id.equals("ore_" + metal + "_deepslate") || id.equals(metal + "_deepslate_ore") || id.equals(metal + "_ore_deepslate") || id.equals("deepslate_ore_" + metal) || id.equals("ore_deepslate_" + metal)) {
                return MetalType.ORE_DEEPSLATE;
            }
            if (id.equals("raw_" + metal + "_storage_block") || id.equals("storage_block_" + metal + "_raw") || id.equals("raw_" + metal + "_storage") || id.equals("storage_" + metal + "_raw") || id.equals("raw_" + metal + "_block") || id.equals("block_" + metal + "_raw") || id.equals(metal + "_raw_storage_block") || id.equals("storage_block_raw_" + metal) || id.equals(metal + "_raw_storage") || id.equals("storage_raw_" + metal) || id.equals(metal + "_raw_block") || id.equals("block_raw_" + metal) || id.equals(metal + "_storage_block_raw") || id.equals("raw_storage_block_" + metal) || id.equals(metal + "_storage_raw") || id.equals("raw_storage_" + metal) || id.equals(metal + "_block_raw") || id.equals("raw_block_" + metal)) {
                return MetalType.RAW_STORAGE;
            }
        }
        return MetalType.NA;
    }

    public static String remapLocIDs(String id) {
        Object v;
        MetalType check;
        if (id.contains("unify")) {
            return id;
        }
        MetalType type = MetalType.NA;
        ArrayList<String> newList = new ArrayList<String>(MaterialEntry.types);
        newList.sort((a, b) -> Integer.compare(b.length(), a.length()));
        String itemId = id.contains(":") ? id.split(":", 2)[1] : id;
        String metal = "";
        for (String s : newList) {
            if (!itemId.contains(s)) continue;
            metal = s;
            break;
        }
        if ((check = UnifyRemapper.checkTypeForItem(metal, itemId)) != MetalType.NA) {
            type = check;
        }
        if (type == MetalType.NA && metal.equals("gold") && (check = UnifyRemapper.checkTypeForItem("golden", itemId)) != MetalType.NA) {
            type = check;
        }
        if (type == MetalType.NA) {
            return id;
        }
        if (!metal.isEmpty() && (v = MetalEntry.typeEntries.get(metal)) instanceof MetalEntry) {
            MetalEntry entry = (MetalEntry)v;
            return BuiltInRegistries.ITEM.getKey((Object)entry.get(type).get().asItem()).toString();
        }
        return id;
    }

    private static MetalType checkTypeForItem(String metal, String itemId) {
        if (itemId.equals("storage_blocks/" + metal)) {
            return MetalType.STORAGE;
        }
        if (itemId.equals("ingots/" + metal)) {
            return MetalType.INGOT;
        }
        if (itemId.equals("nuggets/" + metal)) {
            return MetalType.NUGGET;
        }
        if (itemId.equals("plates/" + metal)) {
            return MetalType.SHEET;
        }
        if (itemId.equals("gears/" + metal)) {
            return MetalType.GEAR;
        }
        if (itemId.equals("wires/" + metal)) {
            return MetalType.WIRE;
        }
        if (itemId.equals("rods/" + metal)) {
            return MetalType.ROD;
        }
        if (itemId.equals("dusts/" + metal)) {
            return MetalType.DUST;
        }
        if (itemId.equals("raw_materials/" + metal)) {
            return MetalType.RAW;
        }
        if (itemId.equals("dusts/raw_" + metal)) {
            return MetalType.RAW_CRUSHED;
        }
        if (itemId.equals("storage_blocks/raw_" + metal)) {
            return MetalType.RAW_STORAGE;
        }
        if (itemId.equals(metal + "_storage_block") || itemId.equals("storage_block_" + metal) || itemId.equals(metal + "_storage") || itemId.equals("storage_" + metal) || itemId.equals(metal + "_block") || itemId.equals("block_" + metal)) {
            return MetalType.STORAGE;
        }
        if (itemId.equals(metal + "_ingot") || itemId.equals("ingot_" + metal)) {
            return MetalType.INGOT;
        }
        if (itemId.equals(metal + "_nugget") || itemId.equals("nugget_" + metal)) {
            return MetalType.NUGGET;
        }
        if (itemId.equals(metal + "_plate") || itemId.equals("plate_" + metal) || itemId.equals(metal + "_sheet") || itemId.equals("sheet_" + metal)) {
            return MetalType.SHEET;
        }
        if (itemId.equals(metal + "_gear") || itemId.equals("gear_" + metal)) {
            return MetalType.GEAR;
        }
        if (itemId.equals(metal + "_wire") || itemId.equals("wire_" + metal)) {
            return MetalType.WIRE;
        }
        if (itemId.equals(metal + "_rod") || itemId.equals("rod_" + metal)) {
            return MetalType.ROD;
        }
        if (itemId.equals(metal + "_dust") || itemId.equals("dust_" + metal) || itemId.equals(metal + "_crushed") || itemId.equals("crushed_" + metal)) {
            return MetalType.DUST;
        }
        if (itemId.equals(metal + "_raw") || itemId.equals("raw_" + metal)) {
            return MetalType.RAW;
        }
        if (itemId.equals("crushed_" + metal + "_raw") || itemId.equals("raw_" + metal + "_crushed") || itemId.equals(metal + "_crushed_raw") || itemId.equals(metal + "_raw_crushed") || itemId.equals("crushed_raw_" + metal) || itemId.equals("raw_crushed_" + metal) || itemId.equals("dust_" + metal + "_raw") || itemId.equals("raw_" + metal + "_dust") || itemId.equals(metal + "_dust_raw") || itemId.equals(metal + "_raw_dust") || itemId.equals("dust_raw_" + metal) || itemId.equals("raw_dust_" + metal)) {
            return MetalType.RAW_CRUSHED;
        }
        if (itemId.equals("stone_" + metal + "_ore") || itemId.equals("ore_" + metal + "_stone") || itemId.equals(metal + "_stone_ore") || itemId.equals(metal + "_ore_stone") || itemId.equals("stone_ore_" + metal) || itemId.equals("ore_stone_" + metal) || itemId.equals(metal + "_ore") || itemId.equals("ore_" + metal)) {
            return MetalType.ORE_STONE;
        }
        if (itemId.equals("deepslate_" + metal + "_ore") || itemId.equals("ore_" + metal + "_deepslate") || itemId.equals(metal + "_deepslate_ore") || itemId.equals(metal + "_ore_deepslate") || itemId.equals("deepslate_ore_" + metal) || itemId.equals("ore_deepslate_" + metal)) {
            return MetalType.ORE_DEEPSLATE;
        }
        if (itemId.equals("raw_" + metal + "_storage_block") || itemId.equals("storage_block_" + metal + "_raw") || itemId.equals("raw_" + metal + "_storage") || itemId.equals("storage_" + metal + "_raw") || itemId.equals("raw_" + metal + "_block") || itemId.equals("block_" + metal + "_raw") || itemId.equals(metal + "_raw_storage_block") || itemId.equals("storage_block_raw_" + metal) || itemId.equals(metal + "_raw_storage") || itemId.equals("storage_raw_" + metal) || itemId.equals(metal + "_raw_block") || itemId.equals("block_raw_" + metal) || itemId.equals(metal + "_storage_block_raw") || itemId.equals("raw_storage_block_" + metal) || itemId.equals(metal + "_storage_raw") || itemId.equals("raw_storage_" + metal) || itemId.equals(metal + "_block_raw") || itemId.equals("raw_block_" + metal)) {
            return MetalType.RAW_STORAGE;
        }
        return MetalType.NA;
    }

    /*
     * WARNING - void declaration
     */
    public static void handleRemapping(Map.Entry<ResourceLocation, JsonElement> entry, JsonElement json, JsonObject obj, List<String> outputs, List<String> inner) {
        for (String field : outputs) {
            if (obj.has(field) && obj.get(field).isJsonObject()) {
                String remapped;
                JsonObject inputObj;
                JsonObject target = inputObj = obj.getAsJsonObject(field);
                for (String inside : inner) {
                    if (!inputObj.has(inside) || !inputObj.get(inside).isJsonObject()) continue;
                    target = inputObj.getAsJsonObject(inside);
                    break;
                }
                String id = null;
                String idType = null;
                for (String string : List.of("item", "id", "tag")) {
                    JsonElement targetKey;
                    if (!target.has(string) || (targetKey = target.get(string)) == null || !targetKey.isJsonPrimitive()) continue;
                    id = targetKey.getAsString();
                    idType = string;
                }
                if (id == null || (remapped = UnifyRemapper.remapLocIDs(id)).equals(id)) continue;
                target.remove(idType);
                target.addProperty(idType.equals("tag") ? "item" : idType, remapped);
                continue;
            }
            if (!obj.has(field) || !obj.get(field).isJsonArray()) continue;
            JsonArray array = obj.getAsJsonArray(field);
            for (int i = 0; i < array.size(); ++i) {
                String remapped;
                void var12_18;
                JsonObject ingObj;
                JsonElement elem = array.get(i);
                if (!elem.isJsonObject()) continue;
                JsonObject target = ingObj = elem.getAsJsonObject();
                for (String inside : inner) {
                    if (!ingObj.has(inside) || !ingObj.get(inside).isJsonObject()) continue;
                    target = ingObj.getAsJsonObject(inside);
                    break;
                }
                Object var12_17 = null;
                String idType = null;
                for (String key2 : List.of("item", "id", "tag")) {
                    JsonElement targetKey;
                    if (!target.has(key2) || (targetKey = target.get(key2)) == null || !targetKey.isJsonPrimitive()) continue;
                    String string = targetKey.getAsString();
                    idType = key2;
                }
                if (var12_18 == null || (remapped = UnifyRemapper.remapLocIDs((String)var12_18)).equals(var12_18)) continue;
                target.remove(idType);
                target.addProperty(idType.equals("tag") ? "item" : idType, remapped);
            }
        }
        if (obj.has("key") && obj.get("key").isJsonObject()) {
            JsonObject keyObj = obj.getAsJsonObject("key");
            for (Map.Entry keyEntry : keyObj.entrySet()) {
                String string;
                JsonElement keyVal = (JsonElement)keyEntry.getValue();
                if (!keyVal.isJsonObject()) continue;
                JsonObject ingredient = keyVal.getAsJsonObject();
                String id = null;
                String idType = null;
                for (String key : List.of("item", "id", "tag")) {
                    JsonElement targetKey;
                    if (!ingredient.has(key) || (targetKey = ingredient.get(key)) == null || !targetKey.isJsonPrimitive()) continue;
                    id = targetKey.getAsString();
                    idType = key;
                }
                if (id == null || (string = UnifyRemapper.remapLocIDs(id)).equals(id)) continue;
                ingredient.remove(idType);
                ingredient.addProperty(idType.equals("tag") ? "item" : idType, string);
            }
        }
    }

    public static void remapConfiguredFeature(ResourceLocation id, JsonElement json) {
        if (!json.isJsonObject()) {
            return;
        }
        JsonObject obj = json.getAsJsonObject();
        if (!"minecraft:ore".equals(obj.get("type").getAsString())) {
            return;
        }
        JsonObject config = obj.getAsJsonObject("config");
        if (!config.has("targets") || !config.get("targets").isJsonArray()) {
            return;
        }
        JsonArray targets = config.getAsJsonArray("targets");
        for (int i = 0; i < targets.size(); ++i) {
            String remappedId;
            String originalId;
            JsonObject stateObj;
            JsonObject targetObj;
            JsonElement entry = targets.get(i);
            if (!entry.isJsonObject() || !(targetObj = entry.getAsJsonObject()).has("state") || !(stateObj = targetObj.getAsJsonObject("state")).has("Name") || (originalId = stateObj.get("Name").getAsString()).equals(remappedId = UnifyRemapper.remapID(originalId))) continue;
            stateObj.addProperty("Name", remappedId);
        }
    }
}

