/*
 * Decompiled with CFR 0.152.
 */
package net.mandalacreations.clean_tooltips.client;

import java.util.function.Consumer;
import net.mandalacreations.clean_tooltips.client.TooltipSection;
import net.mandalacreations.clean_tooltips.client.config.ClientConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class DurabilitySection
extends TooltipSection {
    private static final Component DURABILITY = Component.translatable((String)"item.clean_tooltips.durability").withStyle(ChatFormatting.GRAY);
    private final ItemStack stack;

    protected DurabilitySection(Consumer<Component> consumer, ItemStack stack) {
        super(consumer, ClientConfig.INSTANCE.durabilitySectionEnabled());
        this.stack = stack;
    }

    public static void create(Consumer<Component> consumer, ItemStack stack) {
        new DurabilitySection(consumer, stack).create();
    }

    @Override
    protected void buildSection() {
        int maxDamage = this.stack.getMaxDamage();
        int damage = this.stack.getDamageValue();
        ChatFormatting color = ChatFormatting.GREEN;
        int remainingUses = maxDamage - damage;
        if ((double)remainingUses <= (double)maxDamage * 0.1) {
            color = ChatFormatting.RED;
        } else if ((double)remainingUses <= (double)maxDamage * 0.5) {
            color = ChatFormatting.YELLOW;
        }
        this.addComponent((Component)DURABILITY.copy().append((Component)Component.literal((String)(" " + remainingUses)).withStyle(color)).append((Component)Component.literal((String)(" / " + maxDamage))).withStyle(ChatFormatting.GRAY));
    }

    @Override
    public boolean shouldDisplay() {
        return this.stack.isDamaged();
    }
}

