/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.AnimationType;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Fader {
    public static final float[] ZERO_OFFSET = new float[3];
    private static final Vector3f UP = new Vector3f(0.0f, 1.0f, 0.0f);
    private long lastFrameTime = 0L;
    private boolean hasRenderedBefore;
    private float fadeCoeff = 0.0f;
    private float animationProgress = 0.0f;
    private final float[] offset = new float[3];
    private final int chunkX;
    private final int chunkZ;
    private final float fadeChangePerMs;
    private final float animationChangePerMs;

    public Fader(int chunkX, int chunkZ) {
        this(chunkX, chunkZ, Config.fadeChangePerMs, Config.animationChangePerMs);
    }

    public Fader(int chunkX, int chunkZ, float fadeChangePerMs, float animationChangePerMs) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.fadeChangePerMs = fadeChangePerMs;
        this.animationChangePerMs = animationChangePerMs;
    }

    public boolean hasRenderedBefore() {
        return this.hasRenderedBefore;
    }

    public void setRenderedBefore() {
        this.hasRenderedBefore = true;
    }

    public float incrementFadeCoeff(long delta, boolean nearPlayer) {
        if (this.fadeCoeff == 1.0f) {
            return this.fadeCoeff;
        }
        this.fadeCoeff += (float)delta * this.fadeChangePerMs;
        if (this.fadeCoeff > 1.0f) {
            this.fadeCoeff = 1.0f;
        }
        if (!this.hasRenderedBefore() && !Config.fadeNearPlayer && nearPlayer) {
            this.fadeCoeff = 1.0f;
        }
        return Config.fadeCurve.calculate(Float.valueOf(this.fadeCoeff)).floatValue();
    }

    public float[] incrementAnimationOffset(long delta, boolean nearPlayer) {
        if (this.animationProgress == 1.0f) {
            return this.offset;
        }
        this.animationProgress += (float)delta * this.animationChangePerMs;
        if (this.animationProgress > 1.0f) {
            this.animationProgress = 1.0f;
        }
        if (!this.hasRenderedBefore() && !Config.animateNearPlayer && nearPlayer) {
            this.animationProgress = 1.0f;
        }
        float progress = Config.animationCurve.calculate(Float.valueOf(this.animationProgress)).floatValue();
        if (Config.animationType == AnimationType.JAGGED) {
            this.offset[1] = MathUtils.lerp(-Config.animationFactor * 16.0f, 0.0f, progress);
        } else if (Config.animationType == AnimationType.DISPLACEMENT || Config.animationType == AnimationType.SCALE) {
            this.offset[1] = MathUtils.lerp(Config.animationFactor, 0.0f, progress);
        } else if (Config.animationAngle == 0.0f) {
            this.offset[1] = MathUtils.lerp(Config.animationOffset, 0.0f, progress);
        } else {
            Vec3 thisPos = new Vec3((double)(this.chunkX * 16 + 8), 0.0, (double)(this.chunkZ * 16 + 8));
            Vec3 camPos = Fader.getCameraPosition();
            camPos = new Vec3(camPos.x, 0.0, camPos.z);
            Vector3f direction = camPos.toVector3f().sub((Vector3fc)thisPos.toVector3f()).normalize();
            Vector3f axis = new Vector3f((Vector3fc)direction).cross((Vector3fc)UP);
            direction.rotateAxis((float)Math.toRadians(90.0f - Config.animationAngle), axis.x, axis.y, axis.z).mul(Config.animationOffset).lerp((Vector3fc)new Vector3f(), progress);
            if (Config.animationOffset > 0.0f) {
                direction.rotateY((float)Math.PI);
            }
            this.offset[0] = direction.x;
            this.offset[1] = direction.y;
            this.offset[2] = direction.z;
        }
        return this.offset;
    }

    public long calculateAndGetDelta() {
        long currentFrameTime = System.currentTimeMillis();
        long delta = this.lastFrameTime == 0L ? 0L : currentFrameTime - this.lastFrameTime;
        this.lastFrameTime = currentFrameTime;
        return delta;
    }

    public float[] getAnimationOffset() {
        return this.offset;
    }

    public float getFadeCoeff() {
        return this.fadeCoeff;
    }

    private static Vec3 getCameraPosition() {
        Minecraft client = Minecraft.getInstance();
        Entity camera = client.getCameraEntity();
        if (camera == null) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        return camera.position();
    }
}

