/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.compat.sodium.ext.CommandListExt;
import com.koteinik.chunksfadein.compat.sodium.ext.GlBufferUsageExt;
import com.koteinik.chunksfadein.compat.sodium.ext.GlMutableBufferExt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public class DataBuffer {
    private final ByteBuffer buffer;
    private final int stride;
    private final int fieldsCount;

    public DataBuffer(int size, int fieldsCount) {
        this.stride = fieldsCount * 4;
        this.fieldsCount = fieldsCount;
        this.buffer = MemoryUtil.memAlloc((int)(size * this.stride));
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < fieldsCount; ++j) {
                this.put(i, j, 0.0f);
            }
        }
    }

    public void put(int index, int fieldNum, float data) {
        this.buffer.putFloat(this.getPosition(index, fieldNum), data);
    }

    public float get(int index, int fieldNum) {
        return this.buffer.getFloat(this.getPosition(index, fieldNum));
    }

    public void uploadData(CommandListExt commandList, GlMutableBufferExt glBuffer) {
        commandList.uploadData(glBuffer, this.buffer, GlBufferUsageExt.STREAM_DRAW);
    }

    public void reset(int i) {
        for (int j = 0; j < this.fieldsCount; ++j) {
            this.put(i, j, 0.0f);
        }
    }

    public void delete() {
        MemoryUtil.memFree((Buffer)this.buffer);
    }

    private int getPosition(int index, int fieldNum) {
        return index * this.stride + fieldNum * 4;
    }
}

