/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableObject;

public class CurvedTrackSelectionPacket
extends BlockEntityConfigurationPacket<TrackBlockEntity> {
    public static final StreamCodec<ByteBuf, CurvedTrackSelectionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.pos, (StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.targetPos, (StreamCodec)ByteBufCodecs.BOOL, packet -> packet.front, (StreamCodec)ByteBufCodecs.VAR_INT, packet -> packet.segment, (StreamCodec)ByteBufCodecs.VAR_INT, packet -> packet.slot, CurvedTrackSelectionPacket::new);
    private final BlockPos targetPos;
    private final boolean front;
    private final int segment;
    private final int slot;

    public CurvedTrackSelectionPacket(BlockPos pos, BlockPos targetPos, boolean front, int segment, int slot) {
        super(pos);
        this.targetPos = targetPos;
        this.front = front;
        this.segment = segment;
        this.slot = slot;
    }

    @Override
    protected void applySettings(ServerPlayer player, TrackBlockEntity be) {
        if (player.getInventory().selected != this.slot) {
            return;
        }
        ItemStack stack = player.getInventory().getItem(this.slot);
        if (!(stack.getItem() instanceof TrackTargetingBlockItem)) {
            return;
        }
        if (player.isShiftKeyDown() && stack.has(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS)) {
            player.displayClientMessage((Component)CreateLang.translateDirect("track_target.clear", new Object[0]), true);
            stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
            stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
            stack.remove(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
            AllSoundEvents.CONTROLLER_CLICK.play(player.level(), null, (Vec3i)this.pos, 1.0f, 0.5f);
            return;
        }
        EdgePointType<TrackEdgePoint> type = AllBlocks.TRACK_SIGNAL.isIn(stack) ? EdgePointType.SIGNAL : EdgePointType.STATION;
        MutableObject result = new MutableObject(null);
        BezierTrackPointLocation bezierTrackPointLocation = new BezierTrackPointLocation(this.targetPos, this.segment);
        TrackTargetingBlockItem.withGraphLocation(player.level(), this.pos, this.front, bezierTrackPointLocation, type, (overlap, location) -> result.setValue((Object)overlap));
        if (((TrackTargetingBlockItem.OverlapResult)((Object)result.getValue())).feedback != null) {
            player.displayClientMessage((Component)CreateLang.translateDirect(((TrackTargetingBlockItem.OverlapResult)((Object)result.getValue())).feedback, new Object[0]).withStyle(ChatFormatting.RED), true);
            AllSoundEvents.DENY.play(player.level(), null, (Vec3i)this.pos, 0.5f, 1.0f);
            return;
        }
        stack.set(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS, (Object)this.pos);
        stack.set(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, (Object)this.front);
        stack.set(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER, (Object)bezierTrackPointLocation);
        player.displayClientMessage((Component)CreateLang.translateDirect("track_target.set", new Object[0]), true);
        AllSoundEvents.CONTROLLER_CLICK.play(player.level(), null, (Vec3i)this.pos, 1.0f, 1.0f);
    }

    @Override
    protected int maxRange() {
        return (Integer)AllConfigs.server().trains.maxTrackPlacementLength.get() + 16;
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return AllPackets.SELECT_CURVED_TRACK;
    }
}

