/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups;

import de.melanx.simplebackups.BackupChain;
import de.melanx.simplebackups.config.CommonConfig;
import de.melanx.simplebackups.config.ExperimentalConfig;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class BackupChainManager {
    private static final Map<String, BackupChainManager> INSTANCES = new HashMap<String, BackupChainManager>();
    private final List<BackupChain> chains = new ArrayList<BackupChain>();
    private final String levelId;

    private BackupChainManager(String levelId) {
        this.levelId = levelId;
    }

    public static BackupChainManager get(String levelId) {
        return INSTANCES.computeIfAbsent(levelId, str -> {
            BackupChainManager manager = new BackupChainManager((String)str);
            manager.reloadAllChains();
            return manager;
        });
    }

    public void addChain(BackupChain chain) {
        try {
            Files.createDirectories(chain.getParentFolder(), new FileAttribute[0]);
            chain.writeMetadata();
            this.chains.add(chain);
            this.chains.sort(Comparator.comparingLong(BackupChain::getLastUpdated));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create new backup chain", e);
        }
    }

    public BackupChain createChain(String baseName) {
        Path chainDir = CommonConfig.getOutputPath(this.levelId).resolve(baseName);
        Path backupFilePath = Paths.get("full.zip", new String[0]);
        BackupChain backupChain = new BackupChain(chainDir, backupFilePath, ExperimentalConfig.backupType());
        this.addChain(backupChain);
        return backupChain;
    }

    public void removeChain(BackupChain chain) {
        this.chains.remove(chain);
        chain.deleteFiles();
    }

    public List<BackupChain> getChains() {
        return new LinkedList<BackupChain>(this.chains);
    }

    public BackupChain getFirstChain() {
        return this.chains.getFirst();
    }

    @Nullable
    public BackupChain getLatestChain() {
        if (this.chains.isEmpty()) {
            return null;
        }
        return this.chains.getLast();
    }

    public long getFileSize() {
        return this.chains.stream().mapToLong(BackupChain::getFileSize).sum();
    }

    public void reloadAllChains() {
        ArrayList chains = new ArrayList();
        try {
            Path outputPath = CommonConfig.getOutputPath(this.levelId);
            if (!Files.exists(outputPath, new LinkOption[0])) {
                this.chains.clear();
                return;
            }
            Files.walk(outputPath, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(dir -> {
                BackupChain backupChain;
                if (dir.resolve("metadata.json").toFile().exists() && (backupChain = BackupChain.readMetadata(dir)) != null) {
                    chains.add(backupChain);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to reload backup chains for " + this.levelId, e);
        }
        this.chains.clear();
        this.chains.addAll(chains);
        this.chains.sort(Comparator.comparingLong(BackupChain::getLastUpdated));
    }
}

