/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomItemRenderer;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockEntityCustomItemRenderer<T extends BlockEntity>
implements CustomItemRenderer {
    protected final boolean renderItemModel;
    protected final Supplier<T> initEntity;
    protected final BiConsumer<ItemStack, T> entityUpdater;
    protected T blockEntity;

    public BlockEntityCustomItemRenderer(boolean renderItemModel, Supplier<T> initEntity, BiConsumer<ItemStack, T> entityUpdater) {
        this.renderItemModel = renderItemModel;
        this.initEntity = initEntity;
        this.entityUpdater = entityUpdater;
    }

    @Override
    public void render(ItemStack itemStack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        if (this.blockEntity == null) {
            this.blockEntity = (BlockEntity)this.initEntity.get();
            if (this.blockEntity == null) {
                throw new RuntimeException("Init entity function must not return a null block entity!");
            }
        }
        this.entityUpdater.accept(itemStack, (ItemStack)this.blockEntity);
        if (this.renderItemModel) {
            this.renderDefaultModel(itemStack, transformType, poseStack, bufferSource, combinedLight, combinedOverlay);
        }
        ClientUtils.getMinecraft().getBlockEntityRenderDispatcher().renderItem(this.blockEntity, poseStack, bufferSource, combinedLight, combinedOverlay);
    }

    protected void renderDefaultModel(ItemStack itemStack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        Block block;
        if (itemStack.isEmpty()) {
            return;
        }
        ItemRenderer itemRenderer = ClientUtils.getItemRenderer();
        BakedModel model = itemRenderer.getModel(itemStack, null, null, 0);
        boolean fabulous = transformType != ItemDisplayContext.GUI && !transformType.firstPerson() && itemStack.getItem() instanceof BlockItem ? !((block = ((BlockItem)itemStack.getItem()).getBlock()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
        for (BakedModel passModel : model.getRenderPasses(itemStack, fabulous)) {
            for (RenderType renderType : passModel.getRenderTypes(itemStack, fabulous)) {
                VertexConsumer vertexConsumer = fabulous ? ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (boolean)itemStack.hasFoil()) : ItemRenderer.getFoilBuffer((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (boolean)itemStack.hasFoil());
                itemRenderer.renderModelLists(passModel, itemStack, combinedLight, combinedOverlay, poseStack, vertexConsumer);
            }
        }
    }
}

