/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.registry.Registries;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;

public final class ConditionalRecipeSerializer
implements RecipeSerializer<Recipe<?>> {
    public static final RecipeType<Recipe<?>> DUMMY_RECIPE_TYPE = RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"dummy"));
    public static final Recipe<?> DUMMY_RECIPE = new DummyRecipe();
    public static final ConditionalRecipeSerializer INSTANCE = new ConditionalRecipeSerializer();

    public static JsonObject wrapRecipeWithForgeConditions(JsonObject recipe, Collection<ICondition> conditions) {
        JsonObject json = new JsonObject();
        json.addProperty("type", Registries.RECIPE_SERIALIZERS.getIdentifier(INSTANCE).toString());
        JsonArray conditionsJson = new JsonArray();
        for (ICondition condition : conditions) {
            conditionsJson.add((JsonElement)ICondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)condition).getOrThrow());
        }
        json.add("conditions", (JsonElement)conditionsJson);
        json.add("recipe", (JsonElement)recipe);
        return json;
    }

    public static JsonObject wrapRecipe(JsonObject recipe, Collection<ResourceCondition> conditions) {
        return ConditionalRecipeSerializer.wrapRecipeWithForgeConditions(recipe, conditions.stream().map(ResourceCondition::createForgeCondition).collect(Collectors.toList()));
    }

    private ConditionalRecipeSerializer() {
    }

    public static JsonElement unwrapRecipe(ResourceLocation location, JsonObject json, DynamicOps<JsonElement> ops) {
        if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
            throw new RuntimeException("Conditional recipe '" + String.valueOf(location) + "' must have 'conditions' array!");
        }
        if (!json.has("recipe") || !json.get("recipe").isJsonObject()) {
            throw new RuntimeException("Conditional recipe '" + String.valueOf(location) + "' must have 'recipe' object!");
        }
        ICondition.IContext context = (ICondition.IContext)((Pair)ConditionalOps.retrieveContext().codec().decode(ops, (Object)((JsonElement)ops.emptyMap())).getOrThrow()).getFirst();
        JsonArray conditions = json.getAsJsonArray("conditions");
        for (JsonElement conditionElement : conditions) {
            ICondition condition;
            try {
                condition = (ICondition)((Pair)ICondition.CODEC.decode(ops, (Object)conditionElement).getOrThrow()).getFirst();
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered exception whilst testing conditions for recipe '" + String.valueOf(location) + "'!", e);
            }
            if (condition.test(context)) continue;
            return null;
        }
        return json.getAsJsonObject("recipe");
    }

    public MapCodec<Recipe<?>> codec() {
        return MapCodec.unit(null);
    }

    public StreamCodec<RegistryFriendlyByteBuf, Recipe<?>> streamCodec() {
        return StreamCodec.unit(null);
    }

    private static class DummyRecipe
    implements Recipe<RecipeInput> {
        private DummyRecipe() {
        }

        public boolean matches(RecipeInput container, Level level) {
            return false;
        }

        public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
            return ItemStack.EMPTY;
        }

        public boolean canCraftInDimensions(int i, int j) {
            return false;
        }

        public ItemStack getResultItem(HolderLookup.Provider provider) {
            return ItemStack.EMPTY;
        }

        public RecipeSerializer<?> getSerializer() {
            return INSTANCE;
        }

        public RecipeType<?> getType() {
            return DUMMY_RECIPE_TYPE;
        }

        public boolean isIncomplete() {
            return true;
        }
    }
}

