/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.simibubi.create.content.trains.entity.TrainIconType;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TrainInfo;
import de.mrjulsen.crn.data.navigation.ITrainListenerClient;
import de.mrjulsen.crn.data.train.TrainState;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.crn.util.IListenable;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class ClientTrainStop
extends TrainStop
implements ITrainListenerClient<TrainStopRealTimeData>,
IListenable<ClientTrainStop> {
    public static final String EVENT_UPDATE = "update";
    public static final String EVENT_DELAY = "delayed";
    public static final String EVENT_SCHEDULE_CHANGED = "schedule_changed";
    public static final String EVENT_STATION_CHANGED = "station_changed";
    public static final String EVENT_STATION_REACHED = "station_reached";
    public static final String EVENT_STATION_LEFT = "station_left";
    public static final String EVENT_ANNOUNCE_NEXT_STOP = "announce_next_stop";
    private final Map<String, IdentityHashMap<Object, Consumer<ClientTrainStop>>> listeners = new HashMap<String, IdentityHashMap<Object, Consumer<ClientTrainStop>>>();
    private boolean isClosed = false;

    public ClientTrainStop(int scheduleIndex, int sectionIndex, UUID trainId, String trainName, TrainIconType trainIcon, TrainInfo trainInfo, String scheduleTitle, boolean isCustomTitle, String terminusText, int stayDuration, boolean simulated, long scheduledDepartureTime, long scheduledArrivalTime, int cycle, StationTag.ClientStationTag tag, long realTimeArrivalTime, long realTimeDepartureTime, int realTimeCycle, StationTag.ClientStationTag realTimeTag, int realTimeTicksUntilArrival, TrainState trainPosition) {
        super(scheduleIndex, sectionIndex, trainId, trainName, trainIcon, trainInfo, scheduleTitle, isCustomTitle, terminusText, stayDuration, simulated, scheduledDepartureTime, scheduledArrivalTime, cycle, tag, realTimeArrivalTime, realTimeDepartureTime, realTimeCycle, realTimeTag, realTimeTicksUntilArrival, trainPosition);
        this.initEvents();
    }

    private void initEvents() {
        this.createEvent(EVENT_UPDATE);
        this.createEvent(EVENT_DELAY);
        this.createEvent(EVENT_SCHEDULE_CHANGED);
        this.createEvent(EVENT_STATION_CHANGED);
        this.createEvent(EVENT_STATION_REACHED);
        this.createEvent(EVENT_STATION_LEFT);
        this.createEvent(EVENT_ANNOUNCE_NEXT_STOP);
    }

    @Override
    public Map<String, IdentityHashMap<Object, Consumer<ClientTrainStop>>> getListeners() {
        return this.listeners;
    }

    public long getRoundedRealTimeArrivalTime() throws RuntimeSideException {
        if (Platform.getEnvironment() != Env.CLIENT) {
            throw new RuntimeSideException(true);
        }
        return (this.getScheduledArrivalTime() + this.getArrivalTimeDeviation()) / (long)((Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()).intValue() * (long)((Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()).intValue();
    }

    public long getRoundedRealTimeDepartureTime() throws RuntimeSideException {
        if (Platform.getEnvironment() != Env.CLIENT) {
            throw new RuntimeSideException(true);
        }
        return (this.getScheduledDepartureTime() + this.getDepartureTimeDeviation()) / (long)((Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()).intValue() * (long)((Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()).intValue();
    }

    @Override
    public void update(TrainStopRealTimeData data) {
        if (this.isClosed) {
            return;
        }
        if (data.cycle() != this.getScheduledCycle()) {
            if (data.cycle() > this.getScheduledCycle() && this.trainState != TrainState.AFTER) {
                this.trainState = TrainState.AFTER;
                this.notifyListeners(EVENT_STATION_LEFT, this);
                this.close();
            }
            return;
        }
        boolean wasDelayed = this.isDepartureDelayed();
        String oldRealTimeStation = this.getRealTimeStationTag().stationName();
        int oldTimeUntilArrival = this.getTicksUntilArrival();
        if (this.scheduledArrivalTime != data.scheduledArrivalTime() || this.scheduledDepartureTime != data.scheduledDepartureTime()) {
            this.notifyListeners(EVENT_SCHEDULE_CHANGED, this);
        }
        this.scheduledArrivalTime = data.scheduledArrivalTime();
        this.scheduledDepartureTime = data.scheduledDepartureTime();
        this.realTimeArrivalTime = data.realTimeArrivalTime();
        this.realTimeDepartureTime = data.realTimeDepartureTime();
        this.realTimeCycle = data.cycle();
        this.realTimeTag = data.station();
        this.realTimeTicksUntilArrival = data.ticksUntilArrival();
        if (!wasDelayed && this.isAnyDelayed()) {
            this.notifyListeners(EVENT_DELAY, this);
        }
        if (!oldRealTimeStation.equals(this.getRealTimeStationTag().stationName())) {
            this.notifyListeners(EVENT_STATION_CHANGED, this);
        }
        if (this.trainState == TrainState.BEFORE && oldTimeUntilArrival > this.getTicksUntilArrival() && this.getTicksUntilArrival() <= (Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()) {
            this.trainState = TrainState.ANNOUNCED;
            this.notifyListeners(EVENT_ANNOUNCE_NEXT_STOP, this);
        }
        if (this.trainState.getPositionMultiplier() < 0 && this.getTicksUntilArrival() <= 0) {
            this.trainState = TrainState.STAYING;
            this.notifyListeners(EVENT_STATION_REACHED, this);
        }
        this.notifyListeners(EVENT_UPDATE, this);
    }

    public static TrainStop fromNbt(CompoundTag nbt) {
        return new ClientTrainStop(nbt.getInt("ScheduleIndex"), nbt.getInt("SectionIndex"), nbt.getUUID("TrainId"), nbt.getString("TrainName"), TrainIconType.byId((ResourceLocation)ResourceLocation.parse((String)nbt.getString("TrainIcon"))), TrainInfo.fromNbt(nbt.getCompound("TrainInfo")), nbt.getString("ScheduleTitle"), nbt.getBoolean("IsCustomTitle"), nbt.getString("TerminusText"), nbt.getInt("StayDuration"), nbt.getLong("SimulationTime") != 0L, nbt.getLong("ScheduledDeparture"), nbt.getLong("ScheduledArrival"), nbt.getInt("Cycle"), StationTag.ClientStationTag.fromNbt(nbt.getCompound("StationTag")), nbt.getLong("RealArrival"), nbt.getLong("RealDeparture"), nbt.getInt("RealCycle"), StationTag.ClientStationTag.fromNbt(nbt.getCompound("RealTimeTag")), 0, TrainState.BEFORE);
    }

    @Override
    public void close() {
        this.clearEvents();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public record TrainStopRealTimeData(StationTag.ClientStationTag station, int entryIndex, long scheduledArrivalTime, long scheduledDepartureTime, long realTimeArrivalTime, long realTimeDepartureTime, int ticksUntilArrival, int cycle) {
        private static final String NBT_INDEX = "Index";
        private static final String NBT_STATION = "Station";
        private static final String NBT_SCHEDULED_ARRIVAL = "Arrival";
        private static final String NBT_SCHEDULED_DEPARTURE = "Departure";
        private static final String NBT_REAL_TIME_ARRIVAL = "RealArrival";
        private static final String NBT_REAL_TIME_DEPARTURE = "RealDeparture";
        private static final String NBT_CYCLE = "Cycle";
        private static final String NBT_TICKS_UNTIL_ARRIVAL = "TUA";

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.put(NBT_STATION, (Tag)this.station.toNbt());
            nbt.putInt(NBT_INDEX, this.entryIndex);
            nbt.putLong(NBT_SCHEDULED_ARRIVAL, this.scheduledArrivalTime);
            nbt.putLong(NBT_SCHEDULED_DEPARTURE, this.scheduledDepartureTime);
            nbt.putLong(NBT_REAL_TIME_ARRIVAL, this.realTimeArrivalTime);
            nbt.putLong(NBT_REAL_TIME_DEPARTURE, this.realTimeDepartureTime);
            nbt.putInt(NBT_CYCLE, this.cycle);
            nbt.putInt(NBT_TICKS_UNTIL_ARRIVAL, this.ticksUntilArrival);
            return nbt;
        }

        public static TrainStopRealTimeData fromNbt(CompoundTag nbt) {
            return new TrainStopRealTimeData(StationTag.ClientStationTag.fromNbt(nbt.getCompound(NBT_STATION)), nbt.getInt(NBT_INDEX), nbt.getLong(NBT_SCHEDULED_ARRIVAL), nbt.getLong(NBT_SCHEDULED_DEPARTURE), nbt.getLong(NBT_REAL_TIME_ARRIVAL), nbt.getLong(NBT_REAL_TIME_DEPARTURE), nbt.getInt(NBT_TICKS_UNTIL_ARRIVAL), nbt.getInt(NBT_CYCLE));
        }
    }
}

