/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.DLColorPickerScreen;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ColorPickerWidget
extends DLWidgetContainer {
    private int selectedColor = 0;

    public ColorPickerWidget(Screen parent, int px, int py, int[] sampleColors, int maxColorsPerLine, int preselectedColor, boolean allowCustom, boolean allowNone, Consumer<ColorPickerWidget> onPick) {
        super(px, py, 1, 1);
        this.selectedColor = preselectedColor;
        int lines = (int)Math.ceil((double)sampleColors.length / (double)maxColorsPerLine);
        this.set_height(18 * ((allowCustom ? 1 : 0) + (allowNone ? 1 : 0)) + lines * 13 - 1);
        this.set_width(maxColorsPerLine * 13 - 1);
        int currentY = 0;
        if (allowCustom) {
            this.addRenderableWidget((GuiEventListener)new ColorBrowserButton(this.x(), this.y() + currentY, this.width(), () -> this.selectedColor, btn -> DLScreen.setScreen((DLScreen)new DLColorPickerScreen(parent, this.selectedColor, c -> {
                this.selectedColor = c.toInt();
                onPick.accept(this);
            }, true))));
            currentY += 18;
        }
        int i = 0;
        for (int y = 0; y < lines && i < sampleColors.length; ++y) {
            for (int x = 0; x < maxColorsPerLine && i < sampleColors.length; ++x) {
                int j = i++;
                this.addRenderableWidget((GuiEventListener)new ColorButton(this.x() + x * 13, this.y() + currentY + y * 13, sampleColors[j], btn -> {
                    this.selectedColor = sampleColors[j];
                    onPick.accept(this);
                }));
            }
        }
        if (allowNone) {
            this.addRenderableWidget((GuiEventListener)new NoColorButton(this.x(), this.y() + this.height() - 16, this.width(), btn -> {
                this.selectedColor = 0;
                onPick.accept(this);
            }));
        }
    }

    public int getSelectedColor() {
        return this.selectedColor;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    private static class ColorBrowserButton
    extends DLButton {
        private final Supplier<Integer> color;

        public ColorBrowserButton(int pX, int pY, int pWidth, Supplier<Integer> color, Consumer<ColorBrowserButton> pOnPress) {
            super(pX, pY, pWidth, 16, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.color_picker.custom"), pOnPress);
            this.color = color;
        }

        public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
            GuiUtils.drawBox((Graphics)graphics, (GuiAreaDefinition)GuiAreaDefinition.of((AbstractWidget)this), (int)this.color.get(), (int)(this.isMouseSelected() ? -1 : -6381922));
            int n = this.x() + this.width() / 2;
            int n2 = this.y() + this.height() / 2;
            Objects.requireNonNull(this.font);
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)n, (int)(n2 - 9 / 2), (FormattedText)this.getMessage(), (int)-1, (EAlignment)EAlignment.CENTER, (boolean)true);
        }
    }

    private static class ColorButton
    extends DLButton {
        private final int color;

        public ColorButton(int pX, int pY, int color, Consumer<ColorButton> pOnPress) {
            super(pX, pY, 12, 12, (Component)TextUtils.empty(), pOnPress);
            this.color = color;
        }

        public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
            GuiUtils.drawBox((Graphics)graphics, (GuiAreaDefinition)GuiAreaDefinition.of((AbstractWidget)this), (int)this.color, (int)(this.isMouseSelected() ? -1 : -6381922));
            int n = this.x() + this.width() / 2;
            int n2 = this.y() + this.height() / 2;
            Objects.requireNonNull(this.font);
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)n, (int)(n2 - 9 / 2), (FormattedText)this.getMessage(), (int)-1, (EAlignment)EAlignment.CENTER, (boolean)true);
        }
    }

    private static class NoColorButton
    extends DLButton {
        public NoColorButton(int pX, int pY, int pWidth, Consumer<NoColorButton> pOnPress) {
            super(pX, pY, pWidth, 16, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.color_picker.no_color"), pOnPress);
        }

        public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
            GuiUtils.drawBox((Graphics)graphics, (GuiAreaDefinition)GuiAreaDefinition.of((AbstractWidget)this), (int)0, (int)(this.isMouseSelected() ? -1 : -6381922));
            int n = this.x() + this.width() / 2;
            int n2 = this.y() + this.height() / 2;
            Objects.requireNonNull(this.font);
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)n, (int)(n2 - 9 / 2), (FormattedText)this.getMessage(), (int)-1, (EAlignment)EAlignment.CENTER, (boolean)true);
        }
    }
}

