/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class AdvancedDisplaySettingsData
implements INBTSerializable {
    public static final String NBT_SETTINGS = "Settings";
    public static final String NBT_DOUBLE_SIDED = "DoubleSided";
    private IDisplaySettings settings;
    private AdvancedDisplaysRegistry.DisplayTypeResourceKey key;
    private boolean doubleSided;

    public AdvancedDisplaySettingsData() {
    }

    public AdvancedDisplaySettingsData(AdvancedDisplaysRegistry.DisplayTypeResourceKey key, IDisplaySettings settings, boolean doubleSided) {
        this.key = key;
        this.settings = settings;
        this.doubleSided = doubleSided;
    }

    public CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        this.key.toNbt(nbt);
        nbt.put(NBT_SETTINGS, (Tag)this.settings.serializeNbt());
        nbt.putBoolean(NBT_DOUBLE_SIDED, this.doubleSided);
        return nbt;
    }

    public void deserializeNbt(CompoundTag nbt) {
        this.key = AdvancedDisplaysRegistry.DisplayTypeResourceKey.fromNbt(nbt);
        this.settings = AdvancedDisplaysRegistry.createSettings(this.key);
        this.settings.deserializeNbt(nbt.getCompound(NBT_SETTINGS));
        this.doubleSided = nbt.getBoolean(NBT_DOUBLE_SIDED);
    }

    public IDisplaySettings getSettings() {
        return this.settings;
    }

    public AdvancedDisplaysRegistry.DisplayTypeResourceKey getKey() {
        return this.key;
    }

    public boolean isDoubleSided() {
        return this.doubleSided;
    }
}

