/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import de.mrjulsen.crn.block.blockentity.TrainStationClockBlockEntity;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.registry.ModBlockEntities;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrainStationClockBlock
extends Block
implements IWrenchable,
IBE<TrainStationClockBlockEntity> {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty DOUBLE = BooleanProperty.create((String)"double");
    private static final VoxelShape SHAPE_SN = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_EW = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);

    public TrainStationClockBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)DOUBLE, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            player.displayClientMessage((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.time", (Object[])new Object[]{TimeUtils.parseTime((long)((int)(level.getDayTime() % DragonLib.ticksPerDay() + DragonLib.daytimeShift())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))}), true);
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        DyeItem dyeItem;
        DyeColor dye;
        TrainStationClockBlockEntity blockEntity = (TrainStationClockBlockEntity)level.getBlockEntity(pos);
        Item item = stack.getItem();
        if (item instanceof DyeItem && (dye = (dyeItem = (DyeItem)item).getDyeColor()) != null) {
            level.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockEntity.setColor(dye == DyeColor.ORANGE ? 0xFF9900 : dye.getMapColor().col);
            if (level.isClientSide) {
                blockEntity.getRenderer().update(level, pos, state, (BlockEntity)blockEntity, null);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(Items.GLOW_INK_SAC)) {
            level.playSound(null, pos, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockEntity.setGlowing(true);
            if (level.isClientSide) {
                blockEntity.getRenderer().update(level, pos, state, (BlockEntity)blockEntity, null);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (((Boolean)pState.getValue((Property)DOUBLE)).booleanValue()) {
            return Shapes.block();
        }
        return pState.getValue((Property)FACING) == Direction.NORTH || pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE_SN : SHAPE_EW;
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING, DOUBLE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        if (blockState.is((Block)this)) {
            return (BlockState)blockState.setValue((Property)DOUBLE, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return useContext.getItemInHand().is(this.asItem()) && (Boolean)state.getValue((Property)DOUBLE) == false;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public Class<TrainStationClockBlockEntity> getBlockEntityClass() {
        return TrainStationClockBlockEntity.class;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrainStationClockBlockEntity(this.getBlockEntityType(), pos, state);
    }

    public BlockEntityType<? extends TrainStationClockBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.TRAIN_STATION_CLOCK_BLOCK_ENTITY.get();
    }
}

