/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles;

import com.matyrobbrt.keybindbundles.KeyBindBundleManager;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class KeyBindBundle {
    public static final Codec<KeyBindBundle> CODEC = RecordCodecBuilder.create(in -> in.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(k -> k.id), (App)Codec.STRING.fieldOf("name").forGetter(k -> k.name), (App)KeyEntry.CODEC.listOf().fieldOf("entries").forGetter(k -> k.entries), (App)Codec.INT.optionalFieldOf("bookmark", (Object)-1).forGetter(k -> k.bookmark)).apply((Applicative)in, KeyBindBundle::new));
    public static final Codec<List<KeyBindBundle>> LIST_CODEC = CODEC.listOf();
    private final UUID id;
    public final String name;
    private final List<KeyEntry> entries;
    private int bookmark;

    public KeyBindBundle(UUID id, String name, List<KeyEntry> entries, int bookmark) {
        this.id = id;
        this.name = name;
        this.entries = new ArrayList<KeyEntry>(entries);
        this.bookmark = bookmark;
    }

    @Nullable
    public KeyEntry getBookmarked() {
        return this.bookmark < 0 || this.bookmark >= this.entries.size() ? null : this.entries.get(this.bookmark);
    }

    public int getBookmark() {
        return this.bookmark;
    }

    public List<KeyEntry> getEntries() {
        return this.entries;
    }

    public void setBookmark(int bookmark) {
        this.bookmark = bookmark;
    }

    public KeyBindBundleManager.RadialKeyMapping createMapping() {
        return new KeyBindBundleManager.RadialKeyMapping("key.keybindbundles.bundle_" + this.id.toString(), -1, "category.keybindbundles", this);
    }

    public record KeyEntry(String key, String title, ItemStack icon) {
        public static final Codec<KeyEntry> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.STRING.fieldOf("key").forGetter(KeyEntry::key), (App)Codec.STRING.fieldOf("title").forGetter(KeyEntry::title), (App)ItemStack.OPTIONAL_CODEC.lenientOptionalFieldOf("icon", (Object)ItemStack.EMPTY).forGetter(KeyEntry::icon)).apply((Applicative)in, KeyEntry::new));
    }
}

