/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.handler;

import fuzs.fastitemframes.init.ModRegistry;
import fuzs.fastitemframes.world.level.block.ItemFrameBlock;
import fuzs.fastitemframes.world.level.block.entity.ItemFrameBlockEntity;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemFrameHandler {
    public static EventResult onBreakBlock(ServerLevel level, BlockPos pos, BlockState state, Player player, ItemStack itemInHand) {
        ItemFrameBlockEntity blockEntity;
        ItemStack itemStack;
        BlockEntity blockEntity2;
        if (state.is(ModRegistry.ITEM_FRAMES_BLOCK_TAG) && (blockEntity2 = level.getBlockEntity(pos)) instanceof ItemFrameBlockEntity && !(itemStack = (blockEntity = (ItemFrameBlockEntity)blockEntity2).getItem()).isEmpty()) {
            ItemFrame itemFrame = blockEntity.getEntityRepresentation();
            itemFrame.hurt(level.damageSources().playerAttack(player), 1.0f);
            if (itemFrame.getItem().isEmpty()) {
                itemFrame.setInvisible(false);
            }
            blockEntity.markUpdated();
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static EventResult onEntityLoad(Entity entity, ServerLevel serverLevel) {
        if (entity.getType().is(ModRegistry.ITEM_FRAMES_ENTITY_TYPE_TAG) && entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            serverLevel.getServer().tell((Runnable)new TickTask(serverLevel.getServer().getTickCount(), () -> {
                Block block = ItemFrameBlock.BY_ITEM.get(itemFrame.getFrameItemStack().getItem());
                BlockPos blockPos = entity.blockPosition();
                if (block != null && serverLevel.hasChunkAt(blockPos) && serverLevel.isEmptyBlock(blockPos)) {
                    serverLevel.setBlock(blockPos, (BlockState)block.defaultBlockState().setValue((Property)ItemFrameBlock.FACING, (Comparable)itemFrame.getDirection()), 19);
                    BlockEntity patt0$temp = serverLevel.getBlockEntity(blockPos);
                    if (patt0$temp instanceof ItemFrameBlockEntity) {
                        ItemFrameBlockEntity blockEntity = (ItemFrameBlockEntity)patt0$temp;
                        blockEntity.load(itemFrame);
                        blockEntity.setChanged();
                        blockEntity.markUpdated();
                    }
                    entity.discard();
                }
            }));
        }
        return EventResult.PASS;
    }

    public static EventResultHolder<InteractionResult> onUseEntity(Player player, Level level, InteractionHand interactionHand, Entity entity) {
        if (entity.getType().is(ModRegistry.ITEM_FRAMES_ENTITY_TYPE_TAG) && entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            if (!itemFrame.fixed && itemFrame.getItem().isEmpty()) {
                itemFrame.setRotation(0);
            }
            if (player.isSecondaryUseActive()) {
                if (player.getMainHandItem().isEmpty() && player.getOffhandItem().isEmpty() && !itemFrame.getItem().isEmpty()) {
                    itemFrame.setInvisible(!itemFrame.isInvisible());
                    itemFrame.playSound(itemFrame.getRotateItemSound(), 1.0f, 1.0f);
                    return EventResultHolder.interrupt((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
                }
                return EventResultHolder.interrupt((Object)InteractionResult.PASS);
            }
        }
        return EventResultHolder.pass();
    }

    public static EventResult onAttackEntity(Player player, Level level, InteractionHand interactionHand, Entity entity) {
        if (entity.getType().is(ModRegistry.ITEM_FRAMES_ENTITY_TYPE_TAG) && entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            if (!itemFrame.fixed && !itemFrame.getItem().isEmpty()) {
                itemFrame.setInvisible(false);
            }
        }
        return EventResult.PASS;
    }
}

