/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.client;

import fuzs.fastitemframes.FastItemFrames;
import fuzs.fastitemframes.client.handler.ClientItemFrameInteractionHandler;
import fuzs.fastitemframes.client.renderer.blockentity.ItemFrameBlockRenderer;
import fuzs.fastitemframes.init.ModRegistry;
import fuzs.fastitemframes.world.level.block.entity.ItemFrameBlockEntity;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.AdditionalModelsContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.ColorProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class FastItemFramesClient
implements ClientModConstructor {
    public static final ResourceLocation DYED_MODEL_PROPERTY = FastItemFrames.id("dyed");

    public void onConstructMod() {
        FastItemFramesClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        PlayerInteractEvents.ATTACK_BLOCK.register(ClientItemFrameInteractionHandler::onAttackBlock);
    }

    public void onRegisterAdditionalModels(AdditionalModelsContext context) {
        ItemFrameBlockRenderer.ITEM_FRAME_BLOCK_MODELS.values().forEach(xva$0 -> context.registerAdditionalModel(new ResourceLocation[]{xva$0}));
    }

    public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
        context.registerBlockEntityRenderer((BlockEntityType)ModRegistry.ITEM_FRAME_BLOCK_ENTITY.value(), ItemFrameBlockRenderer::new);
    }

    public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
        context.registerItemProperty(DYED_MODEL_PROPERTY, (itemStack, clientLevel, livingEntity, i) -> itemStack.has(DataComponents.DYED_COLOR) ? 1.0f : 0.0f, new ItemLike[]{Items.ITEM_FRAME, Items.GLOW_ITEM_FRAME});
    }

    public void onRegisterBlockColorProviders(ColorProvidersContext<Block, BlockColor> context) {
        context.registerColorProvider((blockState, blockAndTintGetter, blockPos, tintIndex) -> {
            BlockEntity patt0$temp;
            if (blockAndTintGetter != null && blockPos != null && (patt0$temp = blockAndTintGetter.getBlockEntity(blockPos)) instanceof ItemFrameBlockEntity) {
                ItemFrameBlockEntity blockEntity = (ItemFrameBlockEntity)patt0$temp;
                return blockEntity.getColor().orElse(-1);
            }
            return -6265536;
        }, (Object[])new Block[]{(Block)ModRegistry.ITEM_FRAME_BLOCK.value(), (Block)ModRegistry.GLOW_ITEM_FRAME_BLOCK.value()});
    }

    public void onRegisterItemColorProviders(ColorProvidersContext<Item, ItemColor> context) {
        context.registerColorProvider((itemStack, tintIndex) -> tintIndex == 0 ? DyedItemColor.getOrDefault((ItemStack)itemStack, (int)-1) : -1, (Object[])new Item[]{Items.ITEM_FRAME, Items.GLOW_ITEM_FRAME});
    }

    public static ModelResourceLocation id(String path, String variant) {
        return new ModelResourceLocation(FastItemFrames.id(path), variant);
    }
}

