/*
 * Decompiled with CFR 0.152.
 */
package com.kingcontaria.fastquit.util;

import com.kingcontaria.fastquit.config.ModConfigManager;
import com.kingcontaria.fastquit.mixin.accessor.LevelStorageSessionAccessor;
import com.kingcontaria.fastquit.mixin.accessor.MinecraftClientAccessor;
import com.kingcontaria.fastquit.mixin.accessor.MinecraftServerAccessor;
import com.kingcontaria.fastquit.screen.WaitingScreen;
import com.kingcontaria.fastquit.util.ModLogger;
import com.kingcontaria.fastquit.util.TextHelper;
import com.kingcontaria.fastquit.util.WorldInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class SaveManager {
    public static final Map<IntegratedServer, WorldInfo> savingWorlds = Collections.synchronizedMap(new HashMap());
    public static final List<LevelStorageSource.LevelStorageAccess> occupiedSessions = Collections.synchronizedList(new ArrayList());

    public static void exit() {
        try {
            ModLogger.log("Exiting FastQuit.");
            SaveManager.wait(savingWorlds.keySet());
        }
        catch (Throwable throwable) {
            ModLogger.error("Something went horribly wrong when exiting FastQuit!", throwable);
            savingWorlds.forEach((server, info) -> {
                try {
                    server.getRunningThread().join();
                }
                catch (Throwable throwable2) {
                    ModLogger.error("Failed to wait for \"" + server.getWorldData().getLevelName() + "\"", throwable2);
                }
            });
        }
    }

    public static void wait(IntegratedServer server) {
        SaveManager.wait(Collections.singleton(server), null);
    }

    public static void wait(IntegratedServer server, @Nullable CallbackInfo cancellable) {
        SaveManager.wait(Collections.singleton(server), cancellable);
    }

    public static void wait(Collection<IntegratedServer> servers) {
        SaveManager.wait(servers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Collection<IntegratedServer> servers, @Nullable CallbackInfo cancellable) {
        if (servers == null || servers.isEmpty()) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (!client.isSameThread()) {
            if (servers.stream().anyMatch(server -> Thread.currentThread() == server.getRunningThread())) {
                throw new IllegalStateException("Tried to call FastQuit.wait(...) from one of the servers it's supposed to wait for.");
            }
            client.submit(() -> SaveManager.wait(servers)).join();
            return;
        }
        Screen oldScreen = client.screen;
        MutableComponent stillSaving = TextHelper.translatable("fastquit.screen.waiting", String.join((CharSequence)"\" & \"", servers.stream().map(server -> server.getWorldData().getLevelName()).toList()));
        ModLogger.log(stillSaving.getString());
        servers.forEach(server -> server.getRunningThread().setPriority(5));
        try {
            client.setScreen((Screen)new WaitingScreen((Component)stillSaving, cancellable));
            while (servers.stream().anyMatch(server -> !server.isShutdown())) {
                if (cancellable != null && cancellable.isCancelled()) {
                    if (ModConfigManager.getConfig().backgroundPriority != 0) {
                        servers.forEach(server -> server.getRunningThread().setPriority(ModConfigManager.getConfig().backgroundPriority));
                    }
                    ModLogger.log("Cancelled waiting for currently saving worlds.");
                    break;
                }
                ((MinecraftClientAccessor)client).fastquit$render(false);
            }
        }
        finally {
            if (oldScreen != null && oldScreen.getClass().getName().equals("caeruleusTait.WorldGen.gui.screens.WGConfigScreen")) {
                client.screen = oldScreen;
            } else {
                client.forceSetScreen(oldScreen);
            }
        }
    }

    public static Optional<IntegratedServer> getSavingWorld(Path path) {
        return savingWorlds.keySet().stream().filter(server -> ((LevelStorageSessionAccessor)((MinecraftServerAccessor)server).fastquit$getSession()).fastquit$getDirectory().path().equals(path)).findFirst();
    }

    public static Optional<IntegratedServer> getSavingWorld(LevelStorageSource.LevelStorageAccess session) {
        return savingWorlds.keySet().stream().filter(server -> ((MinecraftServerAccessor)server).fastquit$getSession() == session).findFirst();
    }

    public static Optional<LevelStorageSource.LevelStorageAccess> getSession(Path path) {
        return SaveManager.getSavingWorld(path).flatMap(server -> {
            LevelStorageSource.LevelStorageAccess session;
            LevelStorageSource.LevelStorageAccess levelStorageAccess = session = ((MinecraftServerAccessor)server).fastquit$getSession();
            synchronized (session) {
                if (((LevelStorageSessionAccessor)session).fastquit$getLock().isValid()) {
                    occupiedSessions.add(session);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return Optional.of(session);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Optional.empty();
            }
        });
    }
}

