/*
 * Decompiled with CFR 0.152.
 */
package com.kingcontaria.fastquit.screen;

import com.kingcontaria.fastquit.util.ModLogger;
import com.kingcontaria.fastquit.util.TextHelper;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class WaitingScreen
extends GenericMessageScreen {
    private final CallbackInfo callbackInfo;

    public WaitingScreen(Component text, @Nullable CallbackInfo callbackInfo) {
        super(text);
        if (callbackInfo != null && !callbackInfo.isCancellable()) {
            ModLogger.warn("Provided CallbackInfo for \"" + callbackInfo.getId() + "\" is not cancellable!");
            callbackInfo = null;
        }
        this.callbackInfo = callbackInfo;
    }

    public void init() {
        if (this.callbackInfo != null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)TextHelper.BACK, button -> this.onClose()).bounds(this.width - 100 - 5, this.height - 20 - 5, 100, 20).build());
        }
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        String loading = LoadingDotsText.get((long)Util.getMillis());
        context.drawCenteredString(this.font, this.title, this.width / 2, 70, 0xFFFFFF);
        context.drawString(Objects.requireNonNull(this.minecraft).font, loading, (this.width - this.minecraft.font.width(loading)) / 2, 95, 0x808080, false);
    }

    public boolean shouldCloseOnEsc() {
        return this.callbackInfo != null;
    }

    public void onClose() {
        super.onClose();
        if (this.callbackInfo != null) {
            this.callbackInfo.cancel();
        }
    }
}

