/*
 * Decompiled with CFR 0.152.
 */
package com.kingcontaria.fastquit.mixin;

import com.kingcontaria.fastquit.config.ModConfig;
import com.kingcontaria.fastquit.config.ModConfigManager;
import com.kingcontaria.fastquit.util.ModLogger;
import com.kingcontaria.fastquit.util.SaveManager;
import com.kingcontaria.fastquit.util.TextHelper;
import com.kingcontaria.fastquit.util.WorldInfo;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    @Final
    private static Logger LOGGER;

    @Inject(method={"onServerExit"}, at={@At(value="RETURN")})
    private void fastquit$finishSaving(CallbackInfo ci) {
        MinecraftServerMixin minecraftServerMixin = this;
        if (minecraftServerMixin instanceof IntegratedServer) {
            IntegratedServer server = (IntegratedServer)minecraftServerMixin;
            WorldInfo info = SaveManager.savingWorlds.remove(server);
            if (info == null) {
                ModLogger.warn("\"" + server.getWorldData().getLevelName() + "\" was not registered in currently saving worlds!");
                return;
            }
            MutableComponent description = TextHelper.translatable("fastquit.toast." + (info.deleted ? "deleted" : "description"), server.getWorldData().getLevelName());
            if (ModConfigManager.getConfig().showSavingTime != ModConfig.ShowSavingTime.FALSE && !info.deleted) {
                description.append(" (" + info.getTimeSaving() + ")");
            }
            if (ModConfigManager.getConfig().showToasts) {
                Minecraft.getInstance().submit(() -> Minecraft.getInstance().getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.WORLD_BACKUP, (Component)TextHelper.translatable("fastquit.toast.title", new Object[0]), (Component)description)));
            }
            ModLogger.log(description.getString());
        }
    }

    @WrapWithCondition(method={"stopServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;saveAll()V")})
    private boolean fastquit$cancelPlayerSavingIfDeleted(PlayerList playerManager) {
        if (this.isDeleted()) {
            LOGGER.info("Cancelled saving players because level was deleted");
            return false;
        }
        return true;
    }

    @Inject(method={"saveAllChunks"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;next()Ljava/lang/Object;"), @At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;saveDataTag(Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/world/level/storage/WorldData;Lnet/minecraft/nbt/CompoundTag;)V")}, cancellable=true)
    private void fastquit$cancelSavingIfDeleted(CallbackInfoReturnable<Boolean> cir) {
        if (this.isDeleted()) {
            LOGGER.info("Cancelled saving worlds because level was deleted");
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean isDeleted() {
        WorldInfo info = SaveManager.savingWorlds.get(this);
        return info != null && info.deleted;
    }
}

