/*
 * Decompiled with CFR 0.152.
 */
package com.kingcontaria.fastquit.mixin;

import com.kingcontaria.fastquit.config.ModConfigManager;
import com.kingcontaria.fastquit.util.ModLogger;
import com.kingcontaria.fastquit.util.SaveManager;
import com.kingcontaria.fastquit.util.TextHelper;
import com.kingcontaria.fastquit.util.WorldInfo;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Redirect(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/server/IntegratedServer;isShutdown()Z"))
    private boolean fastquit(IntegratedServer server) {
        SaveManager.savingWorlds.put(server, new WorldInfo());
        if (ModConfigManager.getConfig().backgroundPriority != 0) {
            server.getRunningThread().setPriority(ModConfigManager.getConfig().backgroundPriority);
        }
        ModLogger.log("Disconnected \"" + server.getWorldData().getLevelName() + "\" from the client.");
        return true;
    }

    @WrapWithCondition(method={"updateScreenAndTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;runTick(Z)V")})
    private boolean fastquit$doNotOpenSaveScreen(Minecraft client, boolean tick, Screen screen) {
        return ModConfigManager.getConfig().renderSavingScreen || !(screen instanceof GenericMessageScreen) || !screen.getTitle().equals((Object)TextHelper.translatable("menu.savingLevel", new Object[0]));
    }

    @Inject(method={"destroy"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;disconnect()V", shift=At.Shift.AFTER)})
    private void fastquit$waitForSaveOnShutdown(CallbackInfo ci) {
        SaveManager.exit();
    }

    @Inject(method={"crash"}, at={@At(value="HEAD")})
    private static void fastquit$waitForSaveOnCrash(CallbackInfo ci) {
        SaveManager.exit();
    }
}

