/*
 * Decompiled with CFR 0.152.
 */
package com.kingcontaria.fastquit.mixin;

import com.kingcontaria.fastquit.mixin.accessor.LevelInfoAccessor;
import com.kingcontaria.fastquit.mixin.accessor.LevelPropertiesAccessor;
import com.kingcontaria.fastquit.plugin.annotation.Synchronized;
import com.kingcontaria.fastquit.util.ModLogger;
import com.kingcontaria.fastquit.util.SaveManager;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.DirectoryLock;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.WorldData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelStorageSource.LevelStorageAccess.class})
public abstract class LevelStorageSessionMixin {
    @Shadow
    @Final
    private String levelId;

    @Shadow
    @Synchronized
    public abstract PlayerDataStorage createPlayerStorage();

    @Shadow
    @Synchronized
    @Nullable
    public abstract LevelSummary getSummary(Dynamic<?> var1);

    @Shadow
    @Synchronized
    @Nullable
    protected abstract Dynamic<?> getDataTag(boolean var1);

    @Shadow
    @Synchronized
    public abstract void saveDataTag(RegistryAccess var1, WorldData var2, @Nullable CompoundTag var3);

    @Shadow
    @Synchronized
    public abstract void deleteLevel() throws IOException;

    @Shadow
    @Synchronized
    public abstract void renameLevel(String var1) throws IOException;

    @Shadow
    @Synchronized
    public abstract void close() throws IOException;

    @Inject(method={"makeWorldBackup"}, at={@At(value="HEAD")})
    private void fastquit$waitForSaveOnBackup(CallbackInfoReturnable<Long> cir) {
        SaveManager.getSavingWorld((LevelStorageSource.LevelStorageAccess)this).ifPresent(SaveManager::wait);
    }

    @Inject(method={"renameLevel"}, at={@At(value="TAIL")})
    private void fastquit$editSavingWorldName(String name, CallbackInfo ci) {
        SaveManager.getSavingWorld((LevelStorageSource.LevelStorageAccess)this).ifPresent(server -> ((LevelInfoAccessor)((LevelPropertiesAccessor)server.getWorldData()).fastquit$getLevelInfo()).fastquit$setName(name));
    }

    @Inject(method={"deleteLevel"}, at={@At(value="TAIL")})
    private void fastquit$deleteSavingWorld(CallbackInfo ci) {
        SaveManager.getSavingWorld((LevelStorageSource.LevelStorageAccess)this).map(SaveManager.savingWorlds::get).ifPresent(info -> {
            info.deleted = true;
        });
    }

    @WrapWithCondition(method={"close"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/DirectoryLock;close()V")})
    private boolean fastquit$checkSessionClose(DirectoryLock lock) {
        return !SaveManager.occupiedSessions.remove((LevelStorageSource.LevelStorageAccess)this);
    }

    @Inject(method={"checkLock"}, at={@At(value="HEAD")})
    private void fastquit$warnIfUnSynchronizedSessionAccess(CallbackInfo ci) {
        if (!Thread.holdsLock(this)) {
            SaveManager.getSavingWorld((LevelStorageSource.LevelStorageAccess)this).ifPresent(server -> {
                ModLogger.warn("Un-synchronized access to \"" + this.levelId + "\" session!");
                if (!server.isSameThread()) {
                    SaveManager.wait(server);
                }
            });
        }
    }
}

