/*
 * Decompiled with CFR 0.152.
 */
package com.kingcontaria.fastquit.config;

import java.util.HashSet;
import java.util.Set;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;

@Config(name="fastquit")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    public boolean renderSavingScreen = false;
    @ConfigEntry.Gui.Tooltip
    public boolean showToasts = true;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public ShowSavingTime showSavingTime = ShowSavingTime.TRUE;
    @ConfigEntry.Category(value="performance")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(max=10L)
    public int backgroundPriority = 2;
    @ConfigEntry.Category(value="compat")
    @ConfigEntry.Gui.Tooltip
    private boolean allowMultipleServers = true;
    private static final Set<String> MODS_THAT_CONFLICT_WITH_MULTIPLE_SERVERS = new HashSet<String>();

    public boolean allowMultipleServers() {
        if (!MODS_THAT_CONFLICT_WITH_MULTIPLE_SERVERS.isEmpty()) {
            return false;
        }
        return this.allowMultipleServers;
    }

    static {
        Set<String> incompatibleModIDs = Set.of("quilt_biome");
        for (String modID : incompatibleModIDs) {
            ModList.get().getModContainerById(modID).ifPresent(modContainer -> MODS_THAT_CONFLICT_WITH_MULTIPLE_SERVERS.add(modContainer.getModInfo().getDisplayName()));
        }
    }

    public static enum ShowSavingTime implements SelectionListEntry.Translatable
    {
        FALSE,
        TOAST_ONLY,
        TRUE;


        @NotNull
        public String getKey() {
            if (this == TOAST_ONLY) {
                return "fastquit.config.general.showSavingTime.toastsOnly";
            }
            return "text.cloth-config.boolean.value." + (this == TRUE);
        }
    }
}

