/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.register;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.lopyluna.dndecor.DnDecor;
import dev.lopyluna.dndecor.register.DnDecorTags;
import dev.lopyluna.dndecor.register.helpers.wood_types.BlockPattern;
import dev.lopyluna.dndecor.register.helpers.wood_types.VariantEntry;
import java.util.function.Function;
import java.util.function.Supplier;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;

public enum DnDecorStoneTypes {
    STONE(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.STONE),
    PACKED_MUD(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.PACKED_MUD),
    AMETHYST_BLOCK(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.AMETHYST_BLOCK),
    NETHERRACK(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.NETHERRACK),
    BASALT(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.BASALT),
    BLACKSTONE(BlockPattern.VANILLA_RANGE, r -> () -> Blocks.BLACKSTONE),
    WEATHERED_LIMESTONE(BlockPattern.STANDARD_RANGE, r -> r.paletteStoneBlock("weathered_limestone", () -> Blocks.SANDSTONE, true, false).properties(p -> p.mapColor(MapColor.COLOR_LIGHT_GRAY)).register()),
    GABBRO(BlockPattern.STANDARD_RANGE, r -> r.paletteStoneBlock("gabbro", () -> Blocks.POLISHED_DEEPSLATE, true, false).properties(p -> p.destroyTime(1.25f).mapColor(MapColor.TERRACOTTA_LIGHT_GRAY)).recipe((c, p) -> p.smelting(DataIngredient.ingredient((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.GRANITE}), (ItemLike)Items.GRANITE), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 0.1f)).register()),
    DOLOMITE(BlockPattern.STANDARD_RANGE, r -> r.paletteStoneBlock("dolomite", () -> Blocks.TUFF, true, false).properties(p -> p.destroyTime(1.25f).mapColor(MapColor.TERRACOTTA_WHITE)).recipe((c, p) -> p.smelting(DataIngredient.ingredient((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.DIORITE}), (ItemLike)Items.DIORITE), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 0.1f)).register());

    private final Function<CreateRegistrate, NonNullSupplier<Block>> factory;
    private VariantEntry variants;
    public NonNullSupplier<Block> baseBlock;
    public final BlockPattern[] variantTypes;
    public TagKey<Item> materialTag;

    private DnDecorStoneTypes(BlockPattern[] variantTypes, Function<CreateRegistrate, NonNullSupplier<Block>> factory) {
        this.factory = factory;
        this.variantTypes = variantTypes;
    }

    public VariantEntry getVariants() {
        return this.variants;
    }

    public static void register(CreateRegistrate registrate) {
        for (DnDecorStoneTypes paletteStoneVariants : DnDecorStoneTypes.values()) {
            paletteStoneVariants.baseBlock = paletteStoneVariants.factory.apply(registrate);
            String id = Lang.asId((String)paletteStoneVariants.name()).replace("_block", "");
            paletteStoneVariants.materialTag = DnDecorTags.optionalTag(BuiltInRegistries.ITEM, DnDecor.asResource("stone_types/" + id));
            paletteStoneVariants.variants = new VariantEntry(id, paletteStoneVariants);
        }
    }
}

