/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.diagonal_girder;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class DiagonalGirderBlock
extends Block
implements SimpleWaterloggedBlock,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty FACING_UP = BooleanProperty.create((String)"facing_up");
    public static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)11.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)4.0, (double)5.0, (double)4.0, (double)11.0, (double)12.0, (double)12.0)});
    public static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)3.0, (double)3.0, (double)5.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)5.0, (double)5.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)});
    public static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)5.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)4.0, (double)5.0, (double)5.0, (double)12.0, (double)12.0, (double)12.0)});
    public static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)3.0, (double)3.0, (double)11.0, (double)13.0, (double)13.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)12.0, (double)11.0)});
    public static final VoxelShape SHAPE_UP_EAST = Shapes.or((VoxelShape)Block.box((double)11.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)4.0, (double)4.0, (double)4.0, (double)11.0, (double)11.0, (double)12.0)});
    public static final VoxelShape SHAPE_UP_WEST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)3.0, (double)3.0, (double)5.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)5.0, (double)4.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0)});
    public static final VoxelShape SHAPE_UP_NORTH = Shapes.or((VoxelShape)Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)5.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)11.0, (double)12.0)});
    public static final VoxelShape SHAPE_UP_SOUTH = Shapes.or((VoxelShape)Block.box((double)3.0, (double)3.0, (double)11.0, (double)13.0, (double)13.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)11.0, (double)11.0)});

    public DiagonalGirderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING, FACING_UP});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (!((Boolean)state.getValue((Property)FACING_UP)).booleanValue()) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> throw new MatchException(null, null);
                case Direction.NORTH, Direction.UP, Direction.DOWN -> SHAPE_NORTH;
                case Direction.SOUTH -> SHAPE_SOUTH;
                case Direction.EAST -> SHAPE_EAST;
                case Direction.WEST -> SHAPE_WEST;
            };
        }
        if (((Boolean)state.getValue((Property)FACING_UP)).booleanValue()) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> throw new MatchException(null, null);
                case Direction.NORTH, Direction.UP, Direction.DOWN -> SHAPE_UP_NORTH;
                case Direction.SOUTH -> SHAPE_UP_SOUTH;
                case Direction.EAST -> SHAPE_UP_EAST;
                case Direction.WEST -> SHAPE_UP_WEST;
            };
        }
        return SHAPE_NORTH;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult onWrenched = super.onWrenched(state, context);
        if (!onWrenched.consumesAction()) {
            return onWrenched;
        }
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        level.setBlock(pos, (BlockState)state.setValue((Property)FACING_UP, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)FACING_UP) == false)), 2);
        AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, level.random.nextFloat() + 0.5f);
        return onWrenched;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState blockState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, blockState, level, pos, neighborPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        Direction facing = Objects.requireNonNull(context.getPlayer()).getDirection();
        Direction clickedFace = context.getClickedFace();
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            if (clickedFace == Direction.DOWN) {
                return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing.getOpposite())).setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing.getOpposite())).setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        if (clickedFace == Direction.DOWN) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)FACING_UP, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }
}

