/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import plus.dragons.visuality.particle.type.ColorParticleType;

public class WaterCircleParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private static final Quaternionf QUATERNION = new Quaternionf(0.0f, -0.7f, 0.7f, 0.0f);

    private WaterCircleParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, SpriteSet sprites) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.lifetime = 5 + this.random.nextInt(3);
        this.setParticleSpeed(0.0, 0.0, 0.0);
        if (r > 0.0f && g > 0.0f && b > 0.0f) {
            this.setColor(r, g, b);
        }
        this.scale(2.0f + (float)this.random.nextInt(11) / 10.0f);
        this.sprites = sprites;
        this.setSpriteFromAge(sprites);
    }

    public void setColor(int rgbHex) {
        float red = (float)((rgbHex & 0xFF0000) >> 16) / 255.0f;
        float green = (float)((rgbHex & 0xFF00) >> 8) / 255.0f;
        float blue = (float)(rgbHex & 0xFF) / 255.0f;
        this.setColor(red, green, blue);
    }

    public void tick() {
        if (this.age > this.lifetime / 2) {
            this.setAlpha(1.0f - ((float)this.age - (float)(this.lifetime / 2)) / (float)this.lifetime);
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.sprites);
        }
    }

    public void render(VertexConsumer buffer, Camera camera, float ticks) {
        Vec3 vec3 = camera.getPosition();
        float x = (float)(Mth.lerp((double)ticks, (double)this.xo, (double)this.x) - vec3.x());
        float y = (float)(Mth.lerp((double)ticks, (double)this.yo, (double)this.y) - vec3.y());
        float z = (float)(Mth.lerp((double)ticks, (double)this.zo, (double)this.z) - vec3.z());
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.getQuadSize(ticks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vector3fs[i];
            vector3f.rotate((Quaternionfc)QUATERNION);
            vector3f.mul(f4);
            vector3f.add(x, y, z);
        }
        float f7 = this.getU0();
        float f8 = this.getU1();
        float f5 = this.getV0();
        float f6 = this.getV1();
        int j = this.getLightColor(ticks);
        buffer.addVertex(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).setUv(f8, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).setUv(f8, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).setUv(f7, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).setUv(f7, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<ColorParticleType.Options>
    {
        public Particle createParticle(ColorParticleType.Options options, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            return new WaterCircleParticle(world, x, y, z, options.r, options.g, options.b, this.sprites);
        }
    }
}

