/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.mixin;

import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import plus.dragons.visuality.config.Config;
import plus.dragons.visuality.particle.type.ColorScaleParticleType;
import plus.dragons.visuality.registry.VisualityParticles;

@MethodsReturnNonnullByDefault
@Mixin(value={Slime.class})
public abstract class SlimeMixin
extends Mob {
    @Shadow
    public abstract int getSize();

    @Shadow
    public abstract EntityType<? extends Slime> getType();

    private SlimeMixin(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"spawnCustomParticles"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void getParticleType$modify(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)Config.SLIME_ENABLED.get()).booleanValue() && this.getType() == EntityType.SLIME) {
            if (this.level().isClientSide()) {
                int size = this.getSize();
                ColorScaleParticleType.Options particle = switch (size) {
                    case 1 -> ((ColorScaleParticleType)((Object)VisualityParticles.SMALL_SLIME_BLOB.get())).withColor(8978297);
                    case 2 -> ((ColorScaleParticleType)((Object)VisualityParticles.MEDIUM_SLIME_BLOB.get())).withColor(8978297);
                    default -> ((ColorScaleParticleType)((Object)VisualityParticles.BIG_SLIME_BLOB.get())).withColorAndScale(8978297, 2.0f);
                };
                int i = this.getSize();
                for (int j = 0; j < i * 8; ++j) {
                    float f = this.random.nextFloat() * ((float)Math.PI * 2);
                    float f1 = this.random.nextFloat() * 0.5f + 0.5f;
                    float f2 = Mth.sin((float)f) * (float)i * 0.5f * f1;
                    float f3 = Mth.cos((float)f) * (float)i * 0.5f * f1;
                    this.level().addParticle((ParticleOptions)particle, this.getX() + (double)f2, this.getY(), this.getZ() + (double)f3, 0.0, 0.0, 0.0);
                }
            }
            cir.setReturnValue((Object)true);
        }
    }
}

