/*
 * Decompiled with CFR 0.152.
 */
package io.github.lieonlion.quad;

import io.github.lieonlion.quad.registry.QuadFuelRegistry;
import io.github.lieonlion.quad.tags.QuadItemTags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="quad")
public class Quad {
    public static final String MODID = "quad";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Quad");

    public Quad() {
        LOGGER.info("[Quad] Initialising the Quad mod power! >:P");
        NeoForge.EVENT_BUS.addListener(QuadFuelRegistry::onFurnaceFuelBurnTime);
        NeoForge.EVENT_BUS.addListener(event -> {
            Entity patt0$temp = event.getEntity();
            if (patt0$temp instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)patt0$temp;
                if (itemEntity.getItem().is(QuadItemTags.NEVER_DESPAWN)) {
                    itemEntity.setUnlimitedLifetime();
                }
                if (itemEntity.getItem().is(QuadItemTags.NO_GRAVITY)) {
                    itemEntity.setNoGravity(true);
                } else if (itemEntity.isNoGravity()) {
                    itemEntity.setNoGravity(false);
                }
            }
        });
        NeoForge.EVENT_BUS.addListener(event -> QuadFuelRegistry.cacheMap());
        NeoForge.EVENT_BUS.addListener(QuadFuelRegistry::onFurnaceFuelBurnTime);
    }

    public static ResourceLocation asId(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }
}

