/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderHelper;
import net.p3pp3rf1y.sophisticatedcore.util.Easing;
import net.p3pp3rf1y.sophisticatedcore.util.IDoubleBlock;
import net.p3pp3rf1y.sophisticatedcore.util.VoxelOutliner;

public class BlockHighlightRenderer {
    public static final int HIGHLIGHT_DURATION = 40;
    private static Map<Integer, List<BlockPos>> highlightedPositions = new HashMap<Integer, List<BlockPos>>();
    private static long highlightExpireTime = 0L;
    @Nullable
    private static Map<Integer, List<HighlightedBlock>> cachedHighlightedBlocks = new HashMap<Integer, List<HighlightedBlock>>();

    public static void addHighlightedPositions(Map<Integer, List<BlockPos>> highlightPositions) {
        highlightPositions.forEach((color, positions) -> highlightedPositions.computeIfAbsent((Integer)color, k -> new ArrayList()).addAll(positions));
        highlightExpireTime = Minecraft.getInstance().level.getGameTime() + 40L;
        cachedHighlightedBlocks = null;
    }

    public static void render(PoseStack poseStack, float partialTick, Vec3 cameraPos) {
        Minecraft mc = Minecraft.getInstance();
        if (highlightExpireTime < mc.level.getGameTime()) {
            if (!highlightedPositions.isEmpty()) {
                highlightedPositions.clear();
                cachedHighlightedBlocks = null;
            }
            return;
        }
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        if (cachedHighlightedBlocks == null) {
            cachedHighlightedBlocks = new HashMap<Integer, List<HighlightedBlock>>();
            highlightedPositions.forEach((color, positions) -> cachedHighlightedBlocks.put((Integer)color, positions.stream().map(pos -> BlockHighlightRenderer.getHighlightedBlock(mc, pos)).toList()));
        }
        cachedHighlightedBlocks.forEach((color, highlightedBlocks) -> highlightedBlocks.forEach(bh -> BlockHighlightRenderer.renderHighlightedBlock(poseStack, partialTick, cameraPos, bh, mc, buffer, color)));
    }

    private static void renderHighlightedBlock(PoseStack poseStack, float partialTick, Vec3 cameraPos, HighlightedBlock bh, Minecraft mc, MultiBufferSource.BufferSource buffer, int color) {
        poseStack.pushPose();
        poseStack.translate((double)bh.pos.getX() - cameraPos.x(), (double)bh.pos.getY() - cameraPos.y(), (double)bh.pos.getZ() - cameraPos.z());
        poseStack.translate(bh.pivot.x, bh.pivot.y, bh.pivot.z);
        float scale = 1.0f + Easing.EASE_IN_OUT_CUBIC.ease((float)BlockHighlightRenderer.tri01(mc.level.getGameTime(), 15.0, partialTick)) * 0.05f;
        poseStack.scale(scale, scale, scale);
        poseStack.translate(-bh.pivot.x, -bh.pivot.y, -bh.pivot.z);
        BlockHighlightRenderHelper.renderThickEdges(poseStack, (MultiBufferSource)buffer, color, bh.edges(), bh.pos().getX(), bh.pos().getY(), bh.pos().getZ());
        poseStack.popPose();
    }

    private static HighlightedBlock getHighlightedBlock(Minecraft mc, BlockPos pos) {
        ClientLevel level = mc.level;
        BlockState state = level.getBlockState(pos);
        VoxelShape shape = state.getShape((BlockGetter)level, pos);
        Block block = state.getBlock();
        if (block instanceof IDoubleBlock) {
            IDoubleBlock doubleBlock = (IDoubleBlock)block;
            VoxelShape finalShape = shape;
            shape = doubleBlock.getOtherPosition(state, pos).map(otherPos -> {
                BlockState otherState = level.getBlockState(otherPos);
                VoxelShape otherShape = otherState.getShape((BlockGetter)level, otherPos);
                otherShape = otherShape.move((double)(otherPos.getX() - pos.getX()), (double)(otherPos.getY() - pos.getY()), (double)(otherPos.getZ() - pos.getZ()));
                return Shapes.join((VoxelShape)finalShape, (VoxelShape)otherShape, (BooleanOp)BooleanOp.OR);
            }).orElse(shape);
        } else if (state.getBlock() instanceof ChestBlock && state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
            Direction connectedDir = ChestBlock.getConnectedDirection((BlockState)state);
            BlockPos otherPos2 = pos.relative(connectedDir);
            BlockState otherState = level.getBlockState(otherPos2);
            VoxelShape otherShape = otherState.getShape((BlockGetter)level, otherPos2);
            otherShape = otherShape.move((double)(otherPos2.getX() - pos.getX()), (double)(otherPos2.getY() - pos.getY()), (double)(otherPos2.getZ() - pos.getZ()));
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)otherShape, (BooleanOp)BooleanOp.OR);
        }
        return new HighlightedBlock(pos, VoxelOutliner.linesFromVoxelShapeSimplified(shape, pos), shape.bounds().getCenter());
    }

    public static double tri01(double ticks, double periodTicks, double phaseOffsetTicks) {
        if (periodTicks <= 0.0) {
            return 0.0;
        }
        double phase = (ticks + phaseOffsetTicks) % periodTicks / (periodTicks - 1.0);
        return 1.0 - Math.abs(2.0 * phase - 1.0);
    }

    private record HighlightedBlock(BlockPos pos, List<VoxelOutliner.Edge> edges, Vec3 pivot) {
    }
}

