/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import java.util.function.Supplier;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.players.PlayerList;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import rikka.lanserverproperties.IShareToLanScreenParamAccessor;
import rikka.lanserverproperties.OpenToLanScreenEx;
import rikka.lanserverproperties.mixin.PlayerListAccessor;

@Mod(value="lanserverproperties")
public class LanServerProperties {
    public static final String MODID = "lanserverproperties";
    public static LanServerProperties INSTANCE = null;
    public static final String mixin_startButton_OnClick = "lambda$init$2";
    public static final String mixin_portEditBox_OnChange = "lambda$init$3";

    public LanServerProperties() {
        if (INSTANCE != null) {
            throw new RuntimeException("Duplicated Class Instantiation: LanServerProperties");
        }
        INSTANCE = this;
        LanServerProperties.safeRunWhenOn(Dist.CLIENT, () -> ClientHandler::registerGuiEventHandler);
    }

    public static void safeRunWhenOn(Dist dist, Supplier<Runnable> toRun) {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            toRun.get().run();
        }
    }

    public static void setMaxPlayers(IntegratedServer server, int num) {
        PlayerList playerList = server.getPlayerList();
        ((PlayerListAccessor)playerList).setMaxPlayers(num);
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void registerGuiEventHandler() {
            NeoForge.EVENT_BUS.addListener(ClientHandler::onGuiPostInit);
            NeoForge.EVENT_BUS.addListener(ClientHandler::onGuiDraw);
        }

        public static void onGuiPostInit(ScreenEvent.Init.Post event) {
            Screen gui = event.getScreen();
            if (gui instanceof ShareToLanScreen) {
                OpenToLanScreenEx hook = ((IShareToLanScreenParamAccessor)gui).getLSPData();
                hook.postInitShareToLanScreen(((IShareToLanScreenParamAccessor)gui).getFont(), event.getListenersList(), arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0), arg_0 -> ((ScreenEvent.Init.Post)event).removeListener(arg_0));
            } else if (gui instanceof PauseScreen) {
                OpenToLanScreenEx.initPauseScreen(gui, event.getListenersList(), arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0));
            }
        }

        public static void onGuiDraw(ScreenEvent.Render.Post event) {
            Screen gui = event.getScreen();
            if (gui instanceof ShareToLanScreen) {
                OpenToLanScreenEx.postDraw(gui, ((IShareToLanScreenParamAccessor)gui).getFont(), event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick());
            }
        }
    }
}

