/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.neoforge.datagen.provider;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.init.ModTags;
import biomesoplenty.neoforge.datagen.BOPBlockFamilies;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class BOPRecipeProvider
extends RecipeProvider {
    public BOPRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> holderLookup) {
        super(output, holderLookup);
    }

    protected void buildRecipes(RecipeOutput output) {
        BOPRecipeProvider.generateForEnabledBlockFamiliesBOP(output, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.FIR_PLANKS, ModTags.Items.FIR_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.PINE_PLANKS, ModTags.Items.PINE_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.MAPLE_PLANKS, ModTags.Items.MAPLE_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.REDWOOD_PLANKS, ModTags.Items.REDWOOD_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.MAHOGANY_PLANKS, ModTags.Items.MAHOGANY_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.JACARANDA_PLANKS, ModTags.Items.JACARANDA_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.PALM_PLANKS, ModTags.Items.PALM_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.WILLOW_PLANKS, ModTags.Items.WILLOW_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.DEAD_PLANKS, ModTags.Items.DEAD_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.MAGIC_PLANKS, ModTags.Items.MAGIC_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.UMBRAN_PLANKS, ModTags.Items.UMBRAN_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.HELLBARK_PLANKS, ModTags.Items.HELLBARK_LOGS, (int)4);
        BOPRecipeProvider.planksFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.EMPYREAL_PLANKS, ModTags.Items.EMPYREAL_LOGS, (int)4);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.FIR_WOOD, (ItemLike)BOPBlocks.FIR_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.PINE_WOOD, (ItemLike)BOPBlocks.PINE_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.MAPLE_WOOD, (ItemLike)BOPBlocks.MAPLE_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.REDWOOD_WOOD, (ItemLike)BOPBlocks.REDWOOD_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.MAHOGANY_WOOD, (ItemLike)BOPBlocks.MAHOGANY_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.JACARANDA_WOOD, (ItemLike)BOPBlocks.JACARANDA_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.PALM_WOOD, (ItemLike)BOPBlocks.PALM_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.WILLOW_WOOD, (ItemLike)BOPBlocks.WILLOW_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.DEAD_WOOD, (ItemLike)BOPBlocks.DEAD_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.MAGIC_WOOD, (ItemLike)BOPBlocks.MAGIC_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.UMBRAN_WOOD, (ItemLike)BOPBlocks.UMBRAN_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.HELLBARK_WOOD, (ItemLike)BOPBlocks.HELLBARK_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.EMPYREAL_WOOD, (ItemLike)BOPBlocks.EMPYREAL_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_FIR_WOOD, (ItemLike)BOPBlocks.STRIPPED_FIR_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_PINE_WOOD, (ItemLike)BOPBlocks.STRIPPED_PINE_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_MAPLE_WOOD, (ItemLike)BOPBlocks.STRIPPED_MAPLE_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_REDWOOD_WOOD, (ItemLike)BOPBlocks.STRIPPED_REDWOOD_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_MAHOGANY_WOOD, (ItemLike)BOPBlocks.STRIPPED_MAHOGANY_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_JACARANDA_WOOD, (ItemLike)BOPBlocks.STRIPPED_JACARANDA_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_PALM_WOOD, (ItemLike)BOPBlocks.STRIPPED_PALM_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_WILLOW_WOOD, (ItemLike)BOPBlocks.STRIPPED_WILLOW_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_DEAD_WOOD, (ItemLike)BOPBlocks.STRIPPED_DEAD_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_MAGIC_WOOD, (ItemLike)BOPBlocks.STRIPPED_MAGIC_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_UMBRAN_WOOD, (ItemLike)BOPBlocks.STRIPPED_UMBRAN_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_HELLBARK_WOOD, (ItemLike)BOPBlocks.STRIPPED_HELLBARK_LOG);
        BOPRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)BOPBlocks.STRIPPED_EMPYREAL_WOOD, (ItemLike)BOPBlocks.STRIPPED_EMPYREAL_LOG);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.FIR_BOAT, (ItemLike)BOPBlocks.FIR_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.PINE_BOAT, (ItemLike)BOPBlocks.PINE_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.MAPLE_BOAT, (ItemLike)BOPBlocks.MAPLE_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.REDWOOD_BOAT, (ItemLike)BOPBlocks.REDWOOD_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.MAHOGANY_BOAT, (ItemLike)BOPBlocks.MAHOGANY_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.JACARANDA_BOAT, (ItemLike)BOPBlocks.JACARANDA_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.PALM_BOAT, (ItemLike)BOPBlocks.PALM_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.WILLOW_BOAT, (ItemLike)BOPBlocks.WILLOW_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.DEAD_BOAT, (ItemLike)BOPBlocks.DEAD_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.MAGIC_BOAT, (ItemLike)BOPBlocks.MAGIC_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.UMBRAN_BOAT, (ItemLike)BOPBlocks.UMBRAN_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.HELLBARK_BOAT, (ItemLike)BOPBlocks.HELLBARK_PLANKS);
        BOPRecipeProvider.woodenBoat((RecipeOutput)output, (ItemLike)BOPItems.EMPYREAL_BOAT, (ItemLike)BOPBlocks.EMPYREAL_PLANKS);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.FIR_CHEST_BOAT, (ItemLike)BOPItems.FIR_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.PINE_CHEST_BOAT, (ItemLike)BOPItems.PINE_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.MAPLE_CHEST_BOAT, (ItemLike)BOPItems.MAPLE_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.REDWOOD_CHEST_BOAT, (ItemLike)BOPItems.REDWOOD_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.MAHOGANY_CHEST_BOAT, (ItemLike)BOPItems.MAHOGANY_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.JACARANDA_CHEST_BOAT, (ItemLike)BOPItems.JACARANDA_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.PALM_CHEST_BOAT, (ItemLike)BOPItems.PALM_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.WILLOW_CHEST_BOAT, (ItemLike)BOPItems.WILLOW_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.DEAD_CHEST_BOAT, (ItemLike)BOPItems.DEAD_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.MAGIC_CHEST_BOAT, (ItemLike)BOPItems.MAGIC_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.UMBRAN_CHEST_BOAT, (ItemLike)BOPItems.UMBRAN_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.HELLBARK_CHEST_BOAT, (ItemLike)BOPItems.HELLBARK_BOAT);
        BOPRecipeProvider.chestBoat((RecipeOutput)output, (ItemLike)BOPItems.EMPYREAL_CHEST_BOAT, (ItemLike)BOPItems.EMPYREAL_BOAT);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.FIR_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_FIR_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.PINE_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_PINE_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.MAPLE_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_MAPLE_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.REDWOOD_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_REDWOOD_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.MAHOGANY_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_MAHOGANY_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.JACARANDA_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_JACARANDA_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.PALM_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_PALM_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.WILLOW_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_WILLOW_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.DEAD_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_DEAD_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.MAGIC_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_MAGIC_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.UMBRAN_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_UMBRAN_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.HELLBARK_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_HELLBARK_LOG);
        BOPRecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)BOPItems.EMPYREAL_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_EMPYREAL_LOG);
        BOPRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_WHITE_SANDSTONE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WHITE_SANDSTONE_SLAB})).unlockedBy("has_white_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.WHITE_SANDSTONE)).unlockedBy("has_chiseled_white_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CHISELED_WHITE_SANDSTONE)).unlockedBy("has_cut_white_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.WHITE_SANDSTONE).define(Character.valueOf('#'), (ItemLike)BOPBlocks.WHITE_SAND).pattern("##").pattern("##").unlockedBy("has_white_sand", BOPRecipeProvider.has((ItemLike)BOPBlocks.WHITE_SAND)).save(output);
        BOPRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.WHITE_SANDSTONE_SLAB, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WHITE_SANDSTONE, BOPBlocks.CHISELED_WHITE_SANDSTONE})).unlockedBy("has_white_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.WHITE_SANDSTONE)).unlockedBy("has_chiseled_white_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CHISELED_WHITE_SANDSTONE)).save(output);
        BOPRecipeProvider.stairBuilder((ItemLike)BOPBlocks.WHITE_SANDSTONE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WHITE_SANDSTONE, BOPBlocks.CHISELED_WHITE_SANDSTONE, BOPBlocks.CUT_WHITE_SANDSTONE})).unlockedBy("has_white_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.WHITE_SANDSTONE)).unlockedBy("has_chiseled_white_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CHISELED_WHITE_SANDSTONE)).unlockedBy("has_cut_white_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE)).save(output);
        BOPRecipeProvider.cut((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        BOPRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.WHITE_SANDSTONE_WALL, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WHITE_SANDSTONE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE.asItem(), (float)0.1f, (int)200).unlockedBy("has_white_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.WHITE_SANDSTONE)).save(output);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.WHITE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.WHITE_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.WHITE_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.WHITE_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.WHITE_SANDSTONE_WALL, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_WHITE_SANDSTONE, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE);
        BOPRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_ORANGE_SANDSTONE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ORANGE_SANDSTONE_SLAB})).unlockedBy("has_orange_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.ORANGE_SANDSTONE)).unlockedBy("has_chiseled_orange_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CHISELED_ORANGE_SANDSTONE)).unlockedBy("has_cut_orange_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE).define(Character.valueOf('#'), (ItemLike)BOPBlocks.ORANGE_SAND).pattern("##").pattern("##").unlockedBy("has_orange_sand", BOPRecipeProvider.has((ItemLike)BOPBlocks.ORANGE_SAND)).save(output);
        BOPRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE_SLAB, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ORANGE_SANDSTONE, BOPBlocks.CHISELED_ORANGE_SANDSTONE})).unlockedBy("has_orange_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.ORANGE_SANDSTONE)).unlockedBy("has_chiseled_orange_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CHISELED_ORANGE_SANDSTONE)).save(output);
        BOPRecipeProvider.stairBuilder((ItemLike)BOPBlocks.ORANGE_SANDSTONE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ORANGE_SANDSTONE, BOPBlocks.CHISELED_ORANGE_SANDSTONE, BOPBlocks.CUT_ORANGE_SANDSTONE})).unlockedBy("has_orange_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.ORANGE_SANDSTONE)).unlockedBy("has_chiseled_orange_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CHISELED_ORANGE_SANDSTONE)).unlockedBy("has_cut_orange_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE)).save(output);
        BOPRecipeProvider.cut((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        BOPRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE_WALL, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ORANGE_SANDSTONE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE.asItem(), (float)0.1f, (int)200).unlockedBy("has_orange_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.ORANGE_SANDSTONE)).save(output);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.ORANGE_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.ORANGE_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE_WALL, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_ORANGE_SANDSTONE, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE);
        BOPRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_BLACK_SANDSTONE, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BLACK_SANDSTONE_SLAB})).unlockedBy("has_black_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.BLACK_SANDSTONE)).unlockedBy("has_chiseled_black_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CHISELED_BLACK_SANDSTONE)).unlockedBy("has_cut_black_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BLACK_SANDSTONE).define(Character.valueOf('#'), (ItemLike)BOPBlocks.BLACK_SAND).pattern("##").pattern("##").unlockedBy("has_black_sand", BOPRecipeProvider.has((ItemLike)BOPBlocks.BLACK_SAND)).save(output);
        BOPRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BLACK_SANDSTONE_SLAB, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BLACK_SANDSTONE, BOPBlocks.CHISELED_BLACK_SANDSTONE})).unlockedBy("has_black_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.BLACK_SANDSTONE)).unlockedBy("has_chiseled_black_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CHISELED_BLACK_SANDSTONE)).save(output);
        BOPRecipeProvider.stairBuilder((ItemLike)BOPBlocks.BLACK_SANDSTONE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BLACK_SANDSTONE, BOPBlocks.CHISELED_BLACK_SANDSTONE, BOPBlocks.CUT_BLACK_SANDSTONE})).unlockedBy("has_black_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.BLACK_SANDSTONE)).unlockedBy("has_chiseled_black_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CHISELED_BLACK_SANDSTONE)).unlockedBy("has_cut_black_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE)).save(output);
        BOPRecipeProvider.cut((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        BOPRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BLACK_SANDSTONE_WALL, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BLACK_SANDSTONE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE.asItem(), (float)0.1f, (int)200).unlockedBy("has_black_sandstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.BLACK_SANDSTONE)).save(output);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BLACK_SANDSTONE_SLAB, (ItemLike)BOPBlocks.BLACK_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE_SLAB, (ItemLike)BOPBlocks.BLACK_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE_SLAB, (ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BLACK_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BLACK_SANDSTONE_WALL, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_BLACK_SANDSTONE, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE_SLAB, (ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE);
        BOPRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_BRIMSTONE_BRICKS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BRIMSTONE_BRICK_SLAB})).unlockedBy("has_brimstone_bricks", BOPRecipeProvider.has((ItemLike)BOPBlocks.BRIMSTONE_BRICKS)).unlockedBy("has_chiseled_brimstone_bricks", BOPRecipeProvider.has((ItemLike)BOPBlocks.CHISELED_BRIMSTONE_BRICKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS, (int)4).define(Character.valueOf('#'), (ItemLike)BOPBlocks.BRIMSTONE).pattern("##").pattern("##").unlockedBy("has_brimstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.BRIMSTONE)).save(output);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS, (ItemLike)BOPBlocks.BRIMSTONE);
        BOPRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_SLAB, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BRIMSTONE_BRICKS})).unlockedBy("has_brimstone_bricks", BOPRecipeProvider.has((ItemLike)BOPBlocks.BRIMSTONE_BRICKS)).save(output);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_SLAB, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS, 2);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_SLAB, (ItemLike)BOPBlocks.BRIMSTONE, 2);
        BOPRecipeProvider.stairBuilder((ItemLike)BOPBlocks.BRIMSTONE_BRICK_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BRIMSTONE_BRICKS})).unlockedBy("has_brimstone_bricks", BOPRecipeProvider.has((ItemLike)BOPBlocks.BRIMSTONE_BRICKS)).save(output);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_STAIRS, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_STAIRS, (ItemLike)BOPBlocks.BRIMSTONE);
        BOPRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_WALL, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_WALL, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_WALL, (ItemLike)BOPBlocks.BRIMSTONE);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_BRIMSTONE_BRICKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_BRIMSTONE_BRICKS, (ItemLike)BOPBlocks.BRIMSTONE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_CLUSTER, (int)2).define(Character.valueOf('#'), (ItemLike)BOPBlocks.BRIMSTONE).pattern("#").pattern("#").unlockedBy("has_brimstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.BRIMSTONE)).save(output);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_CLUSTER, (ItemLike)BOPBlocks.BRIMSTONE, 2);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_BUD, (int)4).requires((ItemLike)BOPBlocks.BRIMSTONE).unlockedBy("has_brimstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.BRIMSTONE)).save(output);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_BUD, (ItemLike)BOPBlocks.BRIMSTONE, 4);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_FUMAROLE).define(Character.valueOf('#'), (ItemLike)BOPBlocks.BRIMSTONE).define(Character.valueOf('F'), (ItemLike)Items.FIRE_CHARGE).pattern(" # ").pattern("#F#").pattern("###").unlockedBy("has_brimstone", BOPRecipeProvider.has((ItemLike)BOPBlocks.BRIMSTONE)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BLACKSTONE_BULB, (int)2).define(Character.valueOf('#'), (ItemLike)Blocks.BLACKSTONE).define(Character.valueOf('O'), (ItemLike)Blocks.CRYING_OBSIDIAN).pattern("O").pattern("#").unlockedBy("has_blackstone", BOPRecipeProvider.has((ItemLike)Blocks.BLACKSTONE)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BLACKSTONE_SPINES, (int)4).requires((ItemLike)Blocks.BLACKSTONE).unlockedBy("has_blackstone", BOPRecipeProvider.has((ItemLike)Blocks.BLACKSTONE)).save(output);
        BOPRecipeProvider.stonecutterResultFromBase(output, RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BLACKSTONE_SPINES, (ItemLike)Blocks.BLACKSTONE, 4);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ALGAL_END_STONE).requires((ItemLike)Blocks.END_STONE).requires((ItemLike)BOPBlocks.ENDERPHYTE).unlockedBy("has_enderphyte", BOPRecipeProvider.has((ItemLike)BOPBlocks.ENDERPHYTE)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.NULL_END_STONE).requires((ItemLike)Blocks.END_STONE).requires((ItemLike)BOPBlocks.NULL_LEAVES).unlockedBy("has_null_leaves", BOPRecipeProvider.has((ItemLike)BOPBlocks.NULL_LEAVES)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.UNMAPPED_END_STONE, (int)4).define(Character.valueOf('#'), (ItemLike)Blocks.END_STONE).define(Character.valueOf('B'), (ItemLike)BOPItems.LIQUID_NULL_BUCKET).pattern(" # ").pattern("#B#").pattern(" # ").unlockedBy("has_liquid_null_bucket", BOPRecipeProvider.has((ItemLike)BOPItems.LIQUID_NULL_BUCKET)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.MOSSY_BLACK_SAND).requires((ItemLike)BOPBlocks.BLACK_SAND).requires((ItemLike)Blocks.MOSS_BLOCK).unlockedBy("has_moss_block", BOPRecipeProvider.has((ItemLike)Blocks.MOSS_BLOCK)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.FLESH).define(Character.valueOf('#'), (ItemLike)Items.ROTTEN_FLESH).define(Character.valueOf('B'), (ItemLike)BOPItems.BLOOD_BUCKET).pattern(" # ").pattern("#B#").pattern(" # ").unlockedBy("has_blood_bucket", BOPRecipeProvider.has((ItemLike)BOPItems.BLOOD_BUCKET)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK).define(Character.valueOf('#'), (ItemLike)BOPItems.ROSE_QUARTZ_CHUNK).pattern("##").pattern("##").unlockedBy("has_rose_quartz_chunk", BOPRecipeProvider.has((ItemLike)BOPItems.ROSE_QUARTZ_CHUNK)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.RED_MAPLE_LEAF_PILE, (int)3).define(Character.valueOf('#'), (ItemLike)BOPBlocks.RED_MAPLE_LEAVES).pattern("###").unlockedBy("has_red_maple_leaves", BOPRecipeProvider.has((ItemLike)BOPBlocks.RED_MAPLE_LEAVES)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.ORANGE_MAPLE_LEAF_PILE, (int)3).define(Character.valueOf('#'), (ItemLike)BOPBlocks.ORANGE_MAPLE_LEAVES).pattern("###").unlockedBy("has_orange_maple_leaves", BOPRecipeProvider.has((ItemLike)BOPBlocks.ORANGE_MAPLE_LEAVES)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.YELLOW_MAPLE_LEAF_PILE, (int)3).define(Character.valueOf('#'), (ItemLike)BOPBlocks.YELLOW_MAPLE_LEAVES).pattern("###").unlockedBy("has_yellow_maple_leaves", BOPRecipeProvider.has((ItemLike)BOPBlocks.YELLOW_MAPLE_LEAVES)).save(output);
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.BROWN_DYE, (ItemLike)BOPBlocks.CATTAIL, "brown_dye", 2);
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.CYAN_DYE, (ItemLike)BOPBlocks.GLOWFLOWER, "cyan_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.GRAY_DYE, (ItemLike)BOPBlocks.WILTED_LILY, "gray_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)BOPBlocks.BLUE_HYDRANGEA, "light_blue_dye", 2);
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)BOPBlocks.ICY_IRIS, "light_blue_dye", 2);
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.LIGHT_GRAY_DYE, (ItemLike)BOPBlocks.ENDBLOOM, "light_gray_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.MAGENTA_DYE, (ItemLike)BOPBlocks.WILDFLOWER, "magenta_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.ORANGE_DYE, (ItemLike)BOPBlocks.BURNING_BLOSSOM, "orange_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.ORANGE_DYE, (ItemLike)BOPBlocks.ORANGE_COSMOS, "orange_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.PINK_DYE, (ItemLike)BOPBlocks.PINK_DAFFODIL, "pink_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.PINK_DYE, (ItemLike)BOPBlocks.PINK_HIBISCUS, "pink_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.PURPLE_DYE, (ItemLike)BOPBlocks.LAVENDER, "purple_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.PURPLE_DYE, (ItemLike)BOPBlocks.TALL_LAVENDER, "purple_dye", 2);
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.PURPLE_DYE, (ItemLike)BOPBlocks.VIOLET, "purple_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.RED_DYE, (ItemLike)BOPBlocks.ROSE, "red_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.RED_DYE, (ItemLike)BOPBlocks.WATERLILY, "red_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.WHITE_DYE, (ItemLike)BOPBlocks.WHITE_LAVENDER, "white_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.WHITE_DYE, (ItemLike)BOPBlocks.TALL_WHITE_LAVENDER, "white_dye", 2);
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.WHITE_DYE, (ItemLike)BOPBlocks.WHITE_PETALS, "white_dye");
        BOPRecipeProvider.oneToOneConversionRecipe(output, (ItemLike)Items.YELLOW_DYE, (ItemLike)BOPBlocks.GOLDENROD, "yellow_dye", 2);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.TINY_CACTUS.asItem()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GREEN_DYE, (float)1.0f, (int)200).unlockedBy("has_tiny_cactus", BOPRecipeProvider.has((ItemLike)BOPBlocks.TINY_CACTUS)).save(output, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)Items.GREEN_DYE, (ItemLike)BOPBlocks.TINY_CACTUS));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.MOSSY_COBBLESTONE).requires((ItemLike)Blocks.COBBLESTONE).requires((ItemLike)BOPBlocks.WILLOW_VINE).group("mossy_cobblestone").unlockedBy("has_willow_vine", BOPRecipeProvider.has((ItemLike)BOPBlocks.WILLOW_VINE)).save(output, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)Blocks.MOSSY_COBBLESTONE, (ItemLike)BOPBlocks.WILLOW_VINE));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.MOSSY_STONE_BRICKS).requires((ItemLike)Blocks.STONE_BRICKS).requires((ItemLike)BOPBlocks.WILLOW_VINE).group("mossy_stone_bricks").unlockedBy("has_willow_vine", BOPRecipeProvider.has((ItemLike)BOPBlocks.WILLOW_VINE)).save(output, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)Blocks.MOSSY_STONE_BRICKS, (ItemLike)BOPBlocks.WILLOW_VINE));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.RABBIT_STEW).requires((ItemLike)Items.BAKED_POTATO).requires((ItemLike)Items.COOKED_RABBIT).requires((ItemLike)Items.BOWL).requires((ItemLike)Items.CARROT).requires((ItemLike)BOPBlocks.TOADSTOOL).group("rabbit_stew").unlockedBy("has_cooked_rabbit", BOPRecipeProvider.has((ItemLike)Items.COOKED_RABBIT)).save(output, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)Items.RABBIT_STEW, (ItemLike)BOPItems.TOADSTOOL));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.TNT).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WHITE_SAND, BOPBlocks.ORANGE_SAND, BOPBlocks.BLACK_SAND})).define(Character.valueOf('X'), (ItemLike)Items.GUNPOWDER).pattern("X#X").pattern("#X#").pattern("X#X").unlockedBy("has_gunpowder", BOPRecipeProvider.has((ItemLike)Items.GUNPOWDER)).save(output, "biomesoplenty:tnt_from_bop_sand");
    }

    protected static void generateForEnabledBlockFamiliesBOP(RecipeOutput output, FeatureFlagSet flags) {
        BOPBlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateRecipe).forEach(family -> BOPRecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)family, (FeatureFlagSet)flags));
    }

    protected static void planksFromLogs(RecipeOutput output, ItemLike planks, ItemLike log, int count) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (int)count).requires(log).group("planks").unlockedBy("has_logs", BOPRecipeProvider.has((ItemLike)log)).save(output);
    }

    protected static void stonecutterResultFromBase(RecipeOutput output, RecipeCategory category, ItemLike result, ItemLike input) {
        BOPRecipeProvider.stonecutterResultFromBase(output, category, result, input, 1);
    }

    protected static void stonecutterResultFromBase(RecipeOutput output, RecipeCategory category, ItemLike result, ItemLike input, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)result, (int)count).unlockedBy(BOPRecipeProvider.getHasName((ItemLike)input), BOPRecipeProvider.has((ItemLike)input)).save(output, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)input) + "_stonecutting");
    }

    protected static void oneToOneConversionRecipe(RecipeOutput p_299023_, ItemLike p_176553_, ItemLike p_176554_, @Nullable String p_176555_) {
        BOPRecipeProvider.oneToOneConversionRecipe(p_299023_, p_176553_, p_176554_, p_176555_, 1);
    }

    protected static void oneToOneConversionRecipe(RecipeOutput p_301230_, ItemLike p_176558_, ItemLike p_176559_, @Nullable String p_176560_, int p_176561_) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)p_176558_, (int)p_176561_).requires(p_176559_).group(p_176560_).unlockedBy(BOPRecipeProvider.getHasName((ItemLike)p_176559_), BOPRecipeProvider.has((ItemLike)p_176559_)).save(p_301230_, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)p_176558_, (ItemLike)p_176559_));
    }
}

